/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import bpsim.ElementParameters;
import java.util.List;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.OutputSet;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.EventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.SimulationAttributeSets;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationAttributeSet;

public class CatchEventPropertyWriter
extends EventPropertyWriter {
    private final CatchEvent event;
    private ElementParameters simulationParameters;

    public CatchEventPropertyWriter(CatchEvent event, VariableScope variableScope) {
        super((Event)event, variableScope);
        this.event = event;
    }

    @Override
    public void setAssignmentsInfo(AssignmentsInfo info) {
        ParsedAssignmentsInfo assignmentsInfo = ParsedAssignmentsInfo.of(info);
        List<InitializedVariable.InitializedOutputVariable> outputs = assignmentsInfo.createInitializedOutputVariables(this.getId(), this.variableScope);
        if (outputs.isEmpty()) {
            return;
        }
        if (outputs.size() > 1) {
            throw new IllegalArgumentException("Output Associations should be at most 1 in Catch Events");
        }
        InitializedVariable.InitializedOutputVariable output = outputs.get(0);
        DataOutput dataOutput = output.getDataOutput();
        this.event.getDataOutputs().add((Object)dataOutput);
        this.getOutputSet().getDataOutputRefs().add((Object)dataOutput);
        this.addItemDefinition(dataOutput.getItemSubjectRef());
        DataOutputAssociation dataOutputAssociation = output.getDataOutputAssociation();
        if (dataOutputAssociation != null) {
            this.event.getDataOutputAssociation().add((Object)dataOutputAssociation);
        }
    }

    private OutputSet getOutputSet() {
        OutputSet outputSet = this.event.getOutputSet();
        if (outputSet == null) {
            outputSet = Factories.bpmn2.createOutputSet();
            this.event.setOutputSet(outputSet);
        }
        return outputSet;
    }

    public void setSimulationSet(SimulationAttributeSet simulationSet) {
        this.simulationParameters = SimulationAttributeSets.toElementParameters(simulationSet);
        this.simulationParameters.setElementRef(this.getId());
    }

    @Override
    public ElementParameters getSimulationParameters() {
        return this.simulationParameters;
    }

    @Override
    public void addEventDefinition(EventDefinition eventDefinition) {
        this.event.getEventDefinitions().add((Object)eventDefinition);
    }

    public void setCancelActivity(Boolean value) {
    }
}

