/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class GatewayPropertyWriter
extends PropertyWriter {
    private final Gateway gateway;
    private String defaultGatewayId;

    public GatewayPropertyWriter(Gateway gateway, VariableScope variableScope) {
        super((FlowElement)gateway, variableScope);
        this.gateway = gateway;
    }

    public void setDefaultRoute(String defaultRouteExpression) {
        if (defaultRouteExpression == null) {
            return;
        }
        CustomAttribute.dg.of((BaseElement)this.gateway).set(defaultRouteExpression);
        String[] split = defaultRouteExpression.split(" : ");
        this.defaultGatewayId = split.length == 1 ? split[0] : split[1];
    }

    @Override
    public void setSource(BasePropertyWriter source) {
        this.setDefaultGateway(source);
    }

    @Override
    public void setTarget(BasePropertyWriter target) {
        this.setDefaultGateway(target);
    }

    private void setDefaultGateway(BasePropertyWriter propertyWriter) {
        if (propertyWriter.getElement().getId().equals(this.defaultGatewayId)) {
            if (this.gateway instanceof ExclusiveGateway) {
                ((ExclusiveGateway)this.gateway).setDefault((SequenceFlow)propertyWriter.getElement());
            } else if (this.gateway instanceof InclusiveGateway) {
                ((InclusiveGateway)this.gateway).setDefault((SequenceFlow)propertyWriter.getElement());
            }
        }
    }

    public void setGatewayDirection(Node n) {
        long incoming = this.countEdges(n.getInEdges());
        long outgoing = this.countEdges(n.getOutEdges());
        if (incoming <= 1L && outgoing > 1L) {
            this.gateway.setGatewayDirection(GatewayDirection.DIVERGING);
        } else if (incoming > 1L && outgoing <= 1L) {
            this.gateway.setGatewayDirection(GatewayDirection.CONVERGING);
        } else {
            this.gateway.setGatewayDirection(GatewayDirection.UNSPECIFIED);
        }
    }

    public void setGatewayDirection(GatewayDirection direction) {
        this.gateway.setGatewayDirection(direction);
    }

    private long countEdges(List<Edge> inEdges) {
        return inEdges.stream().filter(e -> e.getContent() instanceof ViewConnector).count();
    }

    String getDefaultGatewayId() {
        return this.defaultGatewayId;
    }
}

