/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.ElementParameters;
import bpsim.Scenario;
import bpsim.ScenarioParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ProcessType;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.DeclarationList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.ElementContainer;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.LanePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.Processes;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.SubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseFileVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseIdPrefix;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.GlobalVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseProcessVariables;

public class ProcessPropertyWriter
extends BasePropertyWriter
implements ElementContainer {
    private static final String defaultRelationshipType = "BPSimData";
    private final Process process;
    private final BPMNDiagram bpmnDiagram;
    private final BPMNPlane bpmnPlane;
    private Map<String, BasePropertyWriter> childElements = new HashMap<String, BasePropertyWriter>();
    private Collection<ElementParameters> simulationParameters = new ArrayList<ElementParameters>();

    public ProcessPropertyWriter(Process process, VariableScope variableScope) {
        super((BaseElement)process, variableScope);
        this.process = process;
        this.bpmnDiagram = Factories.di.createBPMNDiagram();
        this.bpmnDiagram.setId(process.getId());
        this.bpmnPlane = Factories.di.createBPMNPlane();
        this.bpmnDiagram.setPlane(this.bpmnPlane);
    }

    @Override
    public void setId(String value) {
        String sanitized = Objects.nonNull(value) ? value.replaceAll("\\s", "") : value;
        this.process.setId(sanitized);
    }

    public Process getProcess() {
        return this.process;
    }

    public void addChildShape(BPMNShape shape) {
        if (shape == null) {
            return;
        }
        EList planeElement = this.bpmnPlane.getPlaneElement();
        if (planeElement.contains(shape)) {
            throw new IllegalArgumentException("Cannot add the same shape twice: " + shape.getId());
        }
        planeElement.add(shape);
    }

    @Override
    public void addChildEdge(BPMNEdge edge) {
        if (edge == null) {
            return;
        }
        EList planeElement = this.bpmnPlane.getPlaneElement();
        if (planeElement.contains(edge)) {
            throw new IllegalArgumentException("Cannot add the same edge twice: " + edge.getId());
        }
        planeElement.add(edge);
    }

    public BPMNDiagram getBpmnDiagram() {
        this.bpmnDiagram.getPlane().setBpmnElement((BaseElement)this.process);
        return this.bpmnDiagram;
    }

    @Override
    public void addChildElement(BasePropertyWriter p) {
        Processes.addChildElement(p, this.childElements, (FlowElementsContainer)this.process, this.simulationParameters, this.itemDefinitions, this.rootElements);
        this.addChildShape(p.getShape());
        this.addChildEdge(p.getEdge());
        if (p instanceof SubProcessPropertyWriter) {
            this.addSubProcess((SubProcessPropertyWriter)p);
        }
    }

    private void addSubProcess(SubProcessPropertyWriter p) {
        Collection<BasePropertyWriter> childElements = p.getChildElements();
        childElements.forEach(el -> {
            this.addChildShape(el.getShape());
            this.addChildEdge(el.getEdge());
            if (el instanceof SubProcessPropertyWriter) {
                this.addSubProcess((SubProcessPropertyWriter)el);
            }
        });
    }

    @Override
    public Collection<BasePropertyWriter> getChildElements() {
        return this.childElements.values();
    }

    @Override
    public BasePropertyWriter getChildElement(String id) {
        BasePropertyWriter propertyWriter = this.childElements.get(id);
        return propertyWriter;
    }

    public void setName(String value) {
        this.process.setName(value);
    }

    public void setExecutable(Boolean value) {
        this.process.setIsExecutable(value.booleanValue());
    }

    public void setPackage(String value) {
        CustomAttribute.packageName.of((BaseElement)this.process).set(value);
    }

    public void setType(String value) {
        this.process.setProcessType(ProcessType.get((String)value));
    }

    public void setVersion(String value) {
        CustomAttribute.version.of((BaseElement)this.process).set(value);
    }

    public void setAdHoc(Boolean adHoc) {
        CustomAttribute.adHoc.of((BaseElement)this.process).set(adHoc);
    }

    public void setDescription(String value) {
        CustomElement.description.of((BaseElement)this.process).set(value);
    }

    public void setProcessVariables(BaseProcessVariables processVariables) {
        String value = processVariables.getValue();
        DeclarationList declarationList = DeclarationList.fromString(value);
        EList properties = this.process.getProperties();
        declarationList.getDeclarations().forEach(arg_0 -> this.lambda$setProcessVariables$1((List)properties, arg_0));
    }

    public void setCaseFileVariables(CaseFileVariables caseFileVariables) {
        String value = caseFileVariables.getValue();
        DeclarationList declarationList = DeclarationList.fromString(value);
        EList properties = this.process.getProperties();
        declarationList.getDeclarations().forEach(arg_0 -> this.lambda$setCaseFileVariables$2((List)properties, arg_0));
    }

    public void setCaseIdPrefix(CaseIdPrefix caseIdPrefix) {
        CustomElement.caseIdPrefix.of((BaseElement)this.process).set(caseIdPrefix.getValue());
    }

    public void setCaseRoles(CaseRoles roles) {
        CustomElement.caseRole.of((BaseElement)this.process).set(roles.getValue());
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        CustomElement.globalVariables.of((BaseElement)this.process).set(globalVariables.getValue());
    }

    public void setSlaDueDate(SLADueDate slaDueDate) {
        CustomElement.slaDueDate.of((BaseElement)this.process).set(slaDueDate.getValue());
    }

    @Override
    public void addLaneSet(Collection<LanePropertyWriter> lanes) {
        if (lanes.isEmpty()) {
            return;
        }
        LaneSet laneSet = Factories.bpmn2.createLaneSet();
        EList laneList = laneSet.getLanes();
        lanes.forEach(arg_0 -> ProcessPropertyWriter.lambda$addLaneSet$3((List)laneList, arg_0));
        this.process.getLaneSets().add((Object)laneSet);
        lanes.forEach(l -> {
            this.childElements.put(l.getElement().getId(), (BasePropertyWriter)l);
            this.addChildShape(l.getShape());
        });
    }

    public Collection<ElementParameters> getSimulationParameters() {
        return this.simulationParameters;
    }

    public Relationship getRelationship() {
        Relationship relationship = Factories.bpmn2.createRelationship();
        relationship.setType(defaultRelationshipType);
        BPSimDataType simDataType = Factories.bpsim.createBPSimDataType();
        Scenario defaultScenario = Factories.bpsim.createScenario();
        ScenarioParameters scenarioParameters = Factories.bpsim.createScenarioParameters();
        defaultScenario.setId("default");
        defaultScenario.setName("Simulationscenario");
        defaultScenario.setScenarioParameters(scenarioParameters);
        simDataType.getScenario().add((Object)defaultScenario);
        ExtensionAttributeValue extensionElement = Factories.bpmn2.createExtensionAttributeValue();
        relationship.getExtensionValues().add((Object)extensionElement);
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, (Object)simDataType);
        ((ExtensionAttributeValue)relationship.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        defaultScenario.getElementParameters().addAll(this.simulationParameters);
        return relationship;
    }

    private static /* synthetic */ void lambda$addLaneSet$3(List laneList, LanePropertyWriter l) {
        laneList.add(l.getElement());
    }

    private /* synthetic */ void lambda$setCaseFileVariables$2(List properties, VariableDeclaration decl) {
        VariableScope.Variable variable = this.variableScope.declare(this.process.getId(), "caseFile_" + decl.getIdentifier(), decl.getType());
        properties.add(variable.getTypedIdentifier());
        this.itemDefinitions.add(variable.getTypeDeclaration());
    }

    private /* synthetic */ void lambda$setProcessVariables$1(List properties, VariableDeclaration decl) {
        VariableScope.Variable variable = this.variableScope.declare(this.process.getId(), decl.getIdentifier(), decl.getType(), decl.getKpi());
        if (Boolean.parseBoolean(decl.getKpi())) {
            CustomElement.customKPI.of((BaseElement)variable.getTypedIdentifier()).set(true);
        }
        properties.add(variable.getTypedIdentifier());
        this.itemDefinitions.add(variable.getTypeDeclaration());
    }
}

