/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.util.PropertyWriterUtils;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.DiscreteConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class SequenceFlowPropertyWriter
extends PropertyWriter {
    private final SequenceFlow sequenceFlow;
    private BasePropertyWriter source;
    private BasePropertyWriter target;
    private BPMNEdge bpmnEdge;

    public SequenceFlowPropertyWriter(SequenceFlow sequenceFlow, VariableScope variableScope) {
        super((FlowElement)sequenceFlow, variableScope);
        this.sequenceFlow = sequenceFlow;
    }

    public void setAutoConnectionSource(Connection connection) {
        DiscreteConnection c = (DiscreteConnection)connection;
        CustomElement.autoConnectionSource.of((BaseElement)this.sequenceFlow).set(c.isAuto());
    }

    public void setAutoConnectionTarget(Connection connection) {
        DiscreteConnection c = (DiscreteConnection)connection;
        CustomElement.autoConnectionTarget.of((BaseElement)this.sequenceFlow).set(c.isAuto());
    }

    public void setConnection(ViewConnector<? extends BPMNViewDefinition> connector) {
        Connection sourceConnection = (Connection)connector.getSourceConnection().get();
        Connection targetConnection = (Connection)connector.getTargetConnection().get();
        this.setAutoConnectionSource(sourceConnection);
        this.setAutoConnectionTarget(targetConnection);
        ControlPoint[] controlPoints = connector.getControlPoints();
        this.bpmnEdge = PropertyWriterUtils.createBPMNEdge(this.source, this.target, sourceConnection, controlPoints, targetConnection);
        this.bpmnEdge.setBpmnElement((BaseElement)this.sequenceFlow);
    }

    @Override
    public void setSource(BasePropertyWriter pSrc) {
        this.source = pSrc;
        this.sequenceFlow.setSourceRef((FlowNode)pSrc.getElement());
        pSrc.setTarget(this);
    }

    @Override
    public void setTarget(BasePropertyWriter pTgt) {
        this.target = pTgt;
        this.sequenceFlow.setTargetRef((FlowNode)pTgt.getElement());
        pTgt.setSource(this);
    }

    @Override
    public BPMNEdge getEdge() {
        return this.bpmnEdge;
    }

    public void setPriority(String value) {
        if (value != null && !value.isEmpty()) {
            CustomAttribute.priority.of((BaseElement)this.sequenceFlow).set(value);
        }
    }

    public void setConditionExpression(ScriptTypeValue scriptTypeValue) {
        String language = scriptTypeValue.getLanguage();
        String script = scriptTypeValue.getScript();
        if (script != null && !script.isEmpty()) {
            FormalExpression formalExpression = Factories.bpmn2.createFormalExpression();
            String uri = Scripts.scriptLanguageToUri(language);
            formalExpression.setLanguage(uri);
            FormalExpressionBodyHandler.of(formalExpression).setBody(Scripts.asCData(script));
            this.sequenceFlow.setConditionExpression((Expression)formalExpression);
        }
    }
}

