/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.util;

import java.util.Optional;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class PropertyWriterUtils {
    public static BPMNEdge createBPMNEdge(BasePropertyWriter source, BasePropertyWriter target, Connection sourceConnection, ControlPoint[] mid, Connection targetConnection) {
        BPMNEdge bpmnEdge = Factories.di.createBPMNEdge();
        bpmnEdge.setId(Ids.bpmnEdge(source.getShape().getId(), target.getShape().getId()));
        Point2D sourcePt = PropertyWriterUtils.getSourceLocation(source, sourceConnection);
        Point2D targetPt = PropertyWriterUtils.getTargetLocation(target, targetConnection);
        Point sourcePoint = PropertyWriterUtils.pointOf((double)source.getShape().getBounds().getX() + sourcePt.getX(), (double)source.getShape().getBounds().getY() + sourcePt.getY());
        Point targetPoint = PropertyWriterUtils.pointOf((double)target.getShape().getBounds().getX() + targetPt.getX(), (double)target.getShape().getBounds().getY() + targetPt.getY());
        EList waypoints = bpmnEdge.getWaypoint();
        waypoints.add(sourcePoint);
        if (null != mid) {
            for (ControlPoint controlPoint : mid) {
                waypoints.add(PropertyWriterUtils.pointOf(controlPoint.getLocation().getX(), controlPoint.getLocation().getY()));
            }
        }
        waypoints.add(targetPoint);
        return bpmnEdge;
    }

    public static Optional<Node<View, Edge>> getDockSourceNode(Node<? extends View, ?> node) {
        return node.getInEdges().stream().filter(PropertyWriterUtils::isDockEdge).map(Edge::getSourceNode).map(n -> n).findFirst();
    }

    private static boolean isDockEdge(Edge edge) {
        return edge.getContent() instanceof Dock;
    }

    private static Point2D getSourceLocation(BasePropertyWriter source, Connection sourceConnection) {
        Point2D location = sourceConnection.getLocation();
        if (location == null) {
            Bounds bounds = source.getShape().getBounds();
            location = Point2D.create((double)bounds.getWidth(), (double)(bounds.getHeight() / 2.0f));
        }
        return location;
    }

    private static Point2D getTargetLocation(BasePropertyWriter target, Connection targetConnection) {
        Point2D location = targetConnection.getLocation();
        if (location == null) {
            Bounds bounds = target.getShape().getBounds();
            location = Point2D.create((double)0.0, (double)(bounds.getHeight() / 2.0f));
        }
        return location;
    }

    private static Point pointOf(double x, double y) {
        Point pt = Factories.dc.createPoint();
        pt.setX((float)x);
        pt.setY((float)y);
        return pt;
    }
}

