/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.ElementParameters;
import bpsim.Scenario;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingRequest;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;

public class DefinitionResolver {
    static final double DEFAULT_RESOLUTION = 112.5;
    private final Map<String, Signal> signals;
    private final Map<String, ElementParameters> simulationParameters;
    private final Collection<WorkItemDefinition> workItemDefinitions;
    private final Definitions definitions;
    private final Process process;
    private final BPMNDiagram diagram;
    private final double resolutionFactor;
    private final boolean jbpm;
    private final MarshallingRequest.Mode mode;

    public DefinitionResolver(Definitions definitions, Collection<WorkItemDefinition> workItemDefinitions, boolean jbpm, MarshallingRequest.Mode mode) {
        this.definitions = definitions;
        this.signals = this.initSignals(definitions);
        this.simulationParameters = this.initSimulationParameters(definitions);
        this.workItemDefinitions = workItemDefinitions;
        this.process = this.findProcess();
        this.diagram = this.findDiagram();
        this.resolutionFactor = DefinitionResolver.calculateResolutionFactor(this.diagram);
        this.jbpm = jbpm;
        this.mode = mode;
    }

    public DefinitionResolver(Definitions definitions, Collection<WorkItemDefinition> workItemDefinitions) {
        this(definitions, workItemDefinitions, true, MarshallingRequest.Mode.AUTO);
    }

    public BPMNDiagram getDiagram() {
        return this.diagram;
    }

    public double getResolutionFactor() {
        return this.resolutionFactor;
    }

    public boolean isJbpm() {
        return this.jbpm;
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public Process getProcess() {
        return this.process;
    }

    public MarshallingRequest.Mode getMode() {
        return this.mode;
    }

    public Collection<WorkItemDefinition> getWorkItemDefinitions() {
        return this.workItemDefinitions;
    }

    public Optional<Signal> resolveSignal(String id) {
        return Optional.ofNullable(this.signals.get(id));
    }

    public String resolveSignalName(String id) {
        return this.resolveSignal(id).map(Signal::getName).orElse("");
    }

    public Optional<ElementParameters> resolveSimulationParameters(String id) {
        return Optional.ofNullable(this.simulationParameters.get(id));
    }

    private Map<String, Signal> initSignals(Definitions definitions) {
        HashMap<String, Signal> signals = new HashMap<String, Signal>();
        for (RootElement el : definitions.getRootElements()) {
            if (!(el instanceof Signal)) continue;
            signals.put(el.getId(), (Signal)el);
        }
        return signals;
    }

    private Map<String, ElementParameters> initSimulationParameters(Definitions definitions) {
        HashMap<String, ElementParameters> simulationParameters = new HashMap<String, ElementParameters>();
        EList relationships = definitions.getRelationships();
        if (relationships.isEmpty()) {
            return Collections.emptyMap();
        }
        FeatureMap value = ((ExtensionAttributeValue)((Relationship)relationships.get(0)).getExtensionValues().get(0)).getValue();
        Object simData = value.get((EStructuralFeature)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, true);
        List bpsimExtensions = (List)simData;
        if (bpsimExtensions.isEmpty()) {
            return Collections.emptyMap();
        }
        Scenario scenario = (Scenario)((BPSimDataType)bpsimExtensions.get(0)).getScenario().get(0);
        for (ElementParameters parameters : scenario.getElementParameters()) {
            simulationParameters.put(parameters.getElementRef(), parameters);
        }
        return simulationParameters;
    }

    private Process findProcess() {
        return (Process)this.definitions.getRootElements().stream().filter(el -> el instanceof Process).findFirst().get();
    }

    private BPMNDiagram findDiagram() {
        return (BPMNDiagram)this.definitions.getDiagrams().get(0);
    }

    public BPMNShape getShape(String elementId) {
        return this.definitions.getDiagrams().stream().map(BPMNDiagram::getPlane).map(plane -> DefinitionResolver.getShape(plane, elementId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static BPMNShape getShape(BPMNPlane plane, String elementId) {
        return plane.getPlaneElement().stream().filter(dia -> dia instanceof BPMNShape).map(shape -> (BPMNShape)shape).filter(shape -> shape.getBpmnElement().getId().equals(elementId)).findFirst().orElse(null);
    }

    public BPMNEdge getEdge(String elementId) {
        return this.definitions.getDiagrams().stream().map(BPMNDiagram::getPlane).map(plane -> DefinitionResolver.getEdge(plane, elementId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static BPMNEdge getEdge(BPMNPlane plane, String elementId) {
        return plane.getPlaneElement().stream().filter(dia -> dia instanceof BPMNEdge).map(edge -> (BPMNEdge)edge).filter(edge -> edge.getBpmnElement() != null).filter(edge -> edge.getBpmnElement().getId() != null).filter(edge -> edge.getBpmnElement().getId().equals(elementId)).findFirst().orElse(null);
    }

    static double calculateResolutionFactor(BPMNDiagram diagram) {
        float resolution = diagram.getResolution();
        return resolution == 0.0f ? 1.0 : DefinitionResolver.obtainResolutionFactor() / (double)resolution;
    }

    static double obtainResolutionFactor() {
        return 112.5;
    }
}

