/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.DirectGraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddChildNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddDockedNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.graph.processing.index.map.MapIndexBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class GraphBuilder {
    private final GraphCommandExecutionContext executionContext;
    private final GraphCommandFactory commandFactory;
    private final GraphCommandManager commandManager;
    private final Graph<DefinitionSet, Node> graph;

    public GraphBuilder(Graph<DefinitionSet, Node> graph, DefinitionManager definitionManager, TypedFactoryManager typedFactoryManager, RuleManager ruleManager, GraphCommandFactory commandFactory, GraphCommandManager commandManager) {
        this.graph = graph;
        this.executionContext = new DirectGraphCommandExecutionContext(definitionManager, typedFactoryManager.untyped(), (Index)new MapIndexBuilder().build(graph));
        this.commandFactory = commandFactory;
        this.commandManager = commandManager;
    }

    public void render(BpmnNode root) {
        this.clearGraph();
        this.buildGraph(root);
    }

    public void buildGraph(BpmnNode rootNode) {
        this.addNode(rootNode.value());
        rootNode.getEdges().forEach(this::addEdge);
        List<BpmnNode> nodes = rootNode.getChildren();
        ArrayDeque<BpmnNode> workingSet = new ArrayDeque<BpmnNode>(this.prioritized(nodes));
        HashSet<BpmnNode> workedOff = new HashSet<BpmnNode>();
        while (!workingSet.isEmpty()) {
            BpmnNode current = (BpmnNode)workingSet.pop();
            if (workedOff.contains(current)) continue;
            workedOff.add(current);
            workingSet.addAll(this.prioritized(current.getChildren()));
            this.addChildNode(current);
            current.getEdges().forEach(this::addEdge);
        }
    }

    private Collection<BpmnNode> prioritized(List<BpmnNode> children) {
        ArrayDeque<BpmnNode> prioritized = new ArrayDeque<BpmnNode>();
        for (BpmnNode node : children) {
            if (node.isDocked()) {
                prioritized.add(node);
                continue;
            }
            prioritized.push(node);
        }
        return prioritized;
    }

    private void addDockedNode(Node parent, Node candidate) {
        AddDockedNodeCommand addNodeCommand = this.commandFactory.addDockedNode(parent, candidate);
        this.execute((Command<GraphCommandExecutionContext, RuleViolation>)addNodeCommand);
    }

    private void addChildNode(BpmnNode current) {
        this.addChildNode(current.getParent().value(), current.value());
        if (!current.isDocked()) {
            Point2D translationFactors = this.calculateTranslationFactors(current);
            this.translate(current.value(), translationFactors.getX(), translationFactors.getY());
        }
    }

    private Point2D calculateTranslationFactors(BpmnNode current) {
        double xFactor = 0.0;
        double yFactor = 0.0;
        for (BpmnNode parent = current.getParent(); parent != null; parent = parent.getParent()) {
            Bounds bounds = ((View)parent.value().getContent()).getBounds();
            xFactor += bounds.getX();
            yFactor += bounds.getY();
        }
        return Point2D.create((double)xFactor, (double)yFactor);
    }

    private void addChildNode(Node<? extends View, ?> parent, Node<? extends View, ?> child) {
        AddChildNodeCommand addChildNodeCommand = this.commandFactory.addChildNode(parent, child);
        this.execute((Command<GraphCommandExecutionContext, RuleViolation>)addChildNodeCommand);
    }

    private void translate(Node<? extends View, ?> node, double deltaX, double deltaY) {
        Bounds childBounds = ((View)node.getContent()).getBounds();
        double constrainedX = childBounds.getUpperLeft().getX() - deltaX;
        double constrainedY = childBounds.getUpperLeft().getY() - deltaY;
        Point2D coords = Point2D.create((double)constrainedX, (double)constrainedY);
        this.updatePosition(node, coords);
    }

    private void updatePosition(Node node, Point2D position) {
        UpdateElementPositionCommand updateElementPositionCommand = this.commandFactory.updatePosition(node, position);
        this.execute((Command<GraphCommandExecutionContext, RuleViolation>)updateElementPositionCommand);
    }

    private void addNode(Node node) {
        AddNodeCommand addNodeCommand = this.commandFactory.addNode(node);
        this.execute((Command<GraphCommandExecutionContext, RuleViolation>)addNodeCommand);
    }

    private void addEdge(Edge<? extends View<?>, Node> edge, Node source, Connection sourceConnection, List<Point2D> controlPoints, Node target, Connection targetConnection) {
        DeferredCompositeCommand.Builder commandBuilder = new DeferredCompositeCommand.Builder();
        this.addConnector((DeferredCompositeCommand.Builder<GraphCommandExecutionContext, RuleViolation>)commandBuilder, source, edge, sourceConnection);
        ControlPoint[] cps = new ControlPoint[controlPoints.size()];
        for (int i = 0; i < cps.length; ++i) {
            ControlPoint cp = ControlPoint.build((Point2D)controlPoints.get(i));
            this.addControlPoint((DeferredCompositeCommand.Builder<GraphCommandExecutionContext, RuleViolation>)commandBuilder, edge, cp, i);
        }
        this.setTargetNode((DeferredCompositeCommand.Builder<GraphCommandExecutionContext, RuleViolation>)commandBuilder, target, edge, targetConnection);
        this.execute((Command<GraphCommandExecutionContext, RuleViolation>)commandBuilder.build());
    }

    private void addConnector(DeferredCompositeCommand.Builder<GraphCommandExecutionContext, RuleViolation> commandBuilder, Node<? extends View<?>, Edge> sourceNode, Edge<? extends View<?>, Node> edge, Connection connection) {
        commandBuilder.deferCommand(() -> this.commandFactory.addConnector(sourceNode, edge, connection));
    }

    private void setTargetNode(DeferredCompositeCommand.Builder<GraphCommandExecutionContext, RuleViolation> commandBuilder, Node<? extends View<?>, Edge> targetNode, Edge<? extends View<?>, Node> edge, Connection connection) {
        commandBuilder.deferCommand(() -> this.commandFactory.setTargetNode(targetNode, edge, connection));
    }

    private void addControlPoint(DeferredCompositeCommand.Builder<GraphCommandExecutionContext, RuleViolation> commandBuilder, Edge edge, ControlPoint controlPoint, int index) {
        commandBuilder.deferCommand(() -> this.commandFactory.addControlPoint(edge, controlPoint, index));
    }

    private CommandResult<RuleViolation> execute(Command<GraphCommandExecutionContext, RuleViolation> command) {
        return this.commandManager.execute((Object)this.executionContext, command);
    }

    private CommandResult<RuleViolation> clearGraph() {
        return this.commandManager.execute((Object)this.executionContext, (Command)this.commandFactory.clearGraph());
    }

    private void addEdge(BpmnEdge edge) {
        if (edge.isDocked()) {
            this.addDockedNode(edge.getSource().value(), edge.getTarget().value());
        } else {
            BpmnEdge.Simple e = (BpmnEdge.Simple)edge;
            this.addEdge(e.getEdge(), e.getSource().value(), e.getSourceConnection(), e.getControlPoints(), e.getTarget().value(), e.getTargetConnection());
        }
    }
}

