/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.processes;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.ResultComposer;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.PropertyReaderFactory;

final class ProcessConverterDelegate {
    protected final TypedFactoryManager factoryManager;
    protected final PropertyReaderFactory propertyReaderFactory;
    protected final DefinitionResolver definitionResolver;
    private final BaseConverterFactory converterFactory;

    ProcessConverterDelegate(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory, DefinitionResolver definitionResolver, BaseConverterFactory factory) {
        this.factoryManager = typedFactoryManager;
        this.definitionResolver = definitionResolver;
        this.propertyReaderFactory = propertyReaderFactory;
        this.converterFactory = factory;
    }

    Result<Map<String, BpmnNode>> convertChildNodes(BpmnNode firstNode, List<FlowElement> flowElements, List<LaneSet> laneSets) {
        Result<Map<String, BpmnNode>> flowElementsResult = this.convertFlowElements(flowElements);
        Map<String, BpmnNode> freeFloatingNodes = flowElementsResult.value();
        freeFloatingNodes.values().forEach(n -> n.setParent(firstNode));
        Result[] laneSetsResult = this.convertLaneSets(laneSets, freeFloatingNodes, firstNode);
        Map<String, BpmnNode> lanesMap = Stream.of(laneSetsResult).filter(Objects::nonNull).map(v -> (BpmnNode)v.value()).collect(Collectors.toMap(n -> n.value().getUUID(), n -> n));
        freeFloatingNodes.putAll(lanesMap);
        return ResultComposer.compose(freeFloatingNodes, flowElementsResult, ResultComposer.compose(laneSets, laneSetsResult));
    }

    Result<Boolean> convertEdges(BpmnNode processRoot, List<BaseElement> flowElements, Map<String, BpmnNode> nodes) {
        List results = flowElements.stream().map(e -> this.converterFactory.edgeConverter().convertEdge((BaseElement)e, nodes)).filter(Result::isSuccess).collect(Collectors.toList());
        boolean value = results.size() > 0 ? results.stream().map(Result::value).filter(Objects::nonNull).map(processRoot::addEdge).allMatch(Boolean.TRUE::equals) : false;
        return ResultComposer.composeResults(value, results);
    }

    private Result<Map<String, BpmnNode>> convertFlowElements(List<FlowElement> flowElements) {
        List results = flowElements.stream().map(this.converterFactory.flowElementConverter()::convertNode).collect(Collectors.toList());
        Map<String, BpmnNode> resultMap = results.stream().map(Result::value).filter(Objects::nonNull).collect(Collectors.toMap(n -> n.value().getUUID(), n -> n));
        return ResultComposer.composeResults(resultMap, results);
    }

    private Result<BpmnNode>[] convertLane(Lane lane, List<Lane> parents, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        if (lane.getChildLaneSet() != null) {
            parents.add(lane);
            Result<BpmnNode>[] laneSetResult = this.convertLaneSet(lane.getChildLaneSet(), parents, freeFloatingNodes, firstDiagramNode);
            parents.removeIf(parent -> Objects.equals(parent.getId(), lane.getId()));
            return laneSetResult;
        }
        Result<BpmnNode> laneResult = !parents.isEmpty() && lane != parents.get(0) ? this.converterFactory.laneConverter().convert(lane, parents.get(0)) : this.converterFactory.laneConverter().convert(lane);
        Optional<BpmnNode> value = Optional.ofNullable(laneResult.value());
        value.ifPresent(laneNode -> laneNode.setParent(firstDiagramNode));
        value.ifPresent(laneNode -> lane.getFlowNodeRefs().forEach(node -> ((BpmnNode)freeFloatingNodes.get(node.getId())).setParent((BpmnNode)laneNode)));
        return new Result[]{laneResult};
    }

    private Result<BpmnNode>[] convertLaneSets(List<LaneSet> laneSets, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        LinkedList<Result<BpmnNode>> result = new LinkedList<Result<BpmnNode>>();
        for (LaneSet laneSet : laneSets) {
            Result<BpmnNode>[] converted = this.convertLaneSet(laneSet, new LinkedList<Lane>(), freeFloatingNodes, firstDiagramNode);
            result.addAll(Arrays.asList(converted));
        }
        return result.toArray(new Result[result.size()]);
    }

    private Result<BpmnNode>[] convertLaneSet(LaneSet laneSet, List<Lane> parents, Map<String, BpmnNode> freeFloatingNodes, BpmnNode firstDiagramNode) {
        EList lanes = laneSet.getLanes();
        LinkedList<Result<BpmnNode>> result = new LinkedList<Result<BpmnNode>>();
        for (Lane lane : lanes) {
            Result<BpmnNode>[] converted = this.convertLane(lane, parents, freeFloatingNodes, firstDiagramNode);
            result.addAll(Arrays.asList(converted));
        }
        return result.toArray(new Result[result.size()]);
    }

    Result<BpmnNode> postConvert(BpmnNode processRoot) {
        return this.converterFactory.newProcessPostConverter().postConvert(processRoot, this.definitionResolver);
    }
}

