/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.emf.common.util.ECollections;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.AssignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.FlowElementPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.SimulationSets;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue;

public class ActivityPropertyReader
extends FlowElementPropertyReader {
    protected static final String EMPTY_ASSIGNMENTS = "||||";
    protected final Activity activity;
    protected final DefinitionResolver definitionResolver;

    public ActivityPropertyReader(Activity activity, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((FlowElement)activity, diagram, definitionResolver.getShape(activity.getId()), definitionResolver.getResolutionFactor());
        this.activity = activity;
        this.definitionResolver = definitionResolver;
    }

    public ScriptTypeListValue getOnEntryAction() {
        return Scripts.onEntry((List<ExtensionAttributeValue>)this.element.getExtensionValues());
    }

    public ScriptTypeListValue getOnExitAction() {
        return Scripts.onExit((List<ExtensionAttributeValue>)this.element.getExtensionValues());
    }

    public SimulationSet getSimulationSet() {
        return this.definitionResolver.resolveSimulationParameters(this.activity.getId()).map(SimulationSets::of).orElse(new SimulationSet());
    }

    public AssignmentsInfo getAssignmentsInfo() {
        AssignmentsInfo info = AssignmentsInfos.of(this.getDataInputs(), this.getDataInputAssociations(), this.getDataOutputs(), this.getDataOutputAssociations(), this.getIOSpecification().isPresent());
        if (info.getValue().isEmpty()) {
            info.setValue(EMPTY_ASSIGNMENTS);
        }
        return info;
    }

    protected Optional<InputOutputSpecification> getIOSpecification() {
        return Optional.ofNullable(this.activity.getIoSpecification());
    }

    protected List<DataInput> getDataInputs() {
        return (List)this.getIOSpecification().map(InputOutputSpecification::getDataInputs).orElse(ECollections.emptyEList());
    }

    protected List<DataOutput> getDataOutputs() {
        return (List)this.getIOSpecification().map(InputOutputSpecification::getDataOutputs).orElse(ECollections.emptyEList());
    }

    protected List<DataInputAssociation> getDataInputAssociations() {
        return this.activity.getDataInputAssociations();
    }

    protected List<DataOutputAssociation> getDataOutputAssociations() {
        return this.activity.getDataOutputAssociations();
    }
}

