/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.dd.dc.Bounds;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.CatchEventPropertyReader;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class BoundaryEventPropertyReader
extends CatchEventPropertyReader {
    private final BoundaryEvent event;

    public BoundaryEventPropertyReader(BoundaryEvent event, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((CatchEvent)event, diagram, definitionResolver);
        this.event = event;
    }

    @Override
    public boolean isCancelActivity() {
        return this.event.isCancelActivity();
    }

    @Override
    protected org.kie.workbench.common.stunner.core.graph.content.Bounds computeBounds(Bounds bounds) {
        Point2D docker = this.getDockerInfo();
        double x = 0.0;
        double y = 0.0;
        if (docker.getX() != 0.0 && docker.getY() != 0.0) {
            x = docker.getX() * this.resolutionFactor;
            y = docker.getY() * this.resolutionFactor;
        } else if (this.event.getAttachedToRef() != null) {
            String activityId = this.event.getAttachedToRef().getId();
            Bounds activityBounds = this.definitionResolver.getShape(activityId).getBounds();
            x = (double)bounds.getX() * this.resolutionFactor - (double)activityBounds.getX() * this.resolutionFactor;
            y = (double)bounds.getY() * this.resolutionFactor - (double)activityBounds.getY() * this.resolutionFactor;
            if (x < -28.0) {
                x = -28.0;
            } else if (x > (double)activityBounds.getWidth() * this.resolutionFactor - 28.0) {
                x = (double)activityBounds.getWidth() * this.resolutionFactor - 28.0;
            }
            if (y < -28.0) {
                y = -28.0;
            } else if (y > (double)activityBounds.getHeight() * this.resolutionFactor - 28.0) {
                y = (double)activityBounds.getHeight() * this.resolutionFactor - 28.0;
            }
        }
        return org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)x, (double)y, (double)(x + 56.0), (double)(y + 56.0));
    }

    Point2D getDockerInfo() {
        return CustomAttribute.dockerInfo.of(this.element).get();
    }
}

