/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.Optional;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.emf.ecore.EObject;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.MultipleInstanceActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskValue;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class GenericServiceTaskPropertyReader
extends MultipleInstanceActivityPropertyReader {
    public static final String JAVA = "Java";
    public static final String WEB_SERVICE = "WebService";
    private final ServiceTask task;

    public GenericServiceTaskPropertyReader(ServiceTask task, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((Activity)task, diagram, definitionResolver);
        this.task = task;
    }

    public GenericServiceTaskValue getGenericServiceTask() {
        GenericServiceTaskValue value = new GenericServiceTaskValue();
        String implementation = Optional.ofNullable(CustomAttribute.serviceImplementation.of((BaseElement)this.task).get()).filter(StringUtils::nonEmpty).orElseGet(() -> this.task.getImplementation());
        value.setServiceImplementation(GenericServiceTaskPropertyReader.getServiceImplementation(implementation));
        String operation = Optional.ofNullable(CustomAttribute.serviceOperation.of((BaseElement)this.task).get()).filter(StringUtils::nonEmpty).orElseGet(() -> Optional.ofNullable(this.task.getOperationRef()).map(Operation::getName).orElse(null));
        value.setServiceOperation(operation);
        value.setInMessageStructure((String)Optional.ofNullable(this.task.getOperationRef()).map(Operation::getInMessageRef).map(Message::getItemRef).map(ItemDefinition::getStructureRef).orElse(null));
        value.setOutMessagetructure((String)Optional.ofNullable(this.task.getOperationRef()).map(Operation::getOutMessageRef).map(Message::getItemRef).map(ItemDefinition::getStructureRef).orElse(null));
        String serviceInterface = Optional.ofNullable(CustomAttribute.serviceInterface.of((BaseElement)this.task).get()).filter(StringUtils::nonEmpty).orElseGet(() -> Optional.ofNullable(this.task.getOperationRef()).map(EObject::eContainer).filter(container -> container instanceof Interface).map(container -> (Interface)container).map(Interface::getName).orElse(null));
        value.setServiceInterface(serviceInterface);
        return value;
    }

    public static String getServiceImplementation(String implementation) {
        return Optional.ofNullable(implementation).filter(StringUtils::nonEmpty).filter(impl -> JAVA.equalsIgnoreCase((String)impl)).map(java -> JAVA).orElse(WEB_SERVICE);
    }

    public boolean isAsync() {
        return (Boolean)CustomElement.async.of(this.element).get();
    }

    public boolean isAdHocAutostart() {
        return (Boolean)CustomElement.autoStart.of(this.element).get();
    }

    public String getSLADueDate() {
        return (String)CustomElement.slaDueDate.of(this.element).get();
    }
}

