/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import com.google.gwt.http.client.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingMessage;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.AssignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.ItemNameReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;

public class InputAssignmentReader {
    private final AssociationDeclaration associationDeclaration;
    private static Logger logger = Logger.getLogger(InputAssignmentReader.class.getName());

    public static Optional<InputAssignmentReader> fromAssociation(DataInputAssociation in) {
        EList sourceList = in.getSourceRef();
        EList assignmentList = in.getAssignment();
        String targetName = ((DataInput)in.getTargetRef()).getName();
        if (AssignmentsInfos.isReservedIdentifier(targetName)) {
            return Optional.empty();
        }
        if (!sourceList.isEmpty()) {
            return Optional.of(new InputAssignmentReader((ItemAwareElement)sourceList.get(0), targetName));
        }
        if (!assignmentList.isEmpty()) {
            return Optional.of(new InputAssignmentReader((Assignment)assignmentList.get(0), targetName));
        }
        logger.log(Level.SEVERE, MarshallingMessage.builder().message("Cannot find SourceRef or Assignment for Target ").toString() + targetName);
        return Optional.empty();
    }

    InputAssignmentReader(Assignment assignment, String targetName) {
        FormalExpression from = (FormalExpression)assignment.getFrom();
        String body = FormalExpressionBodyHandler.of(from).getBody();
        String encodedBody = this.encode(body);
        this.associationDeclaration = new AssociationDeclaration(AssociationDeclaration.Direction.Input, AssociationDeclaration.Type.FromTo, encodedBody, targetName);
    }

    InputAssignmentReader(ItemAwareElement source, String targetName) {
        this.associationDeclaration = new AssociationDeclaration(AssociationDeclaration.Direction.Input, AssociationDeclaration.Type.SourceTarget, ItemNameReader.from(source).getName(), targetName);
    }

    private String encode(String body) {
        return Optional.ofNullable(body).filter(b -> !"null".equals(b)).map(URL::encode).orElse("");
    }

    public AssociationDeclaration getAssociationDeclaration() {
        return this.associationDeclaration;
    }
}

