/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;

public class LanePropertyReader
extends BasePropertyReader {
    private final Lane lane;
    private final BPMNShape parentLaneShape;

    public LanePropertyReader(Lane el, BPMNDiagram diagram, BPMNShape shape, BPMNShape parentLaneShape, double resolutionFactor) {
        super((BaseElement)el, diagram, shape, resolutionFactor);
        this.lane = el;
        this.parentLaneShape = parentLaneShape;
    }

    public LanePropertyReader(Lane el, BPMNDiagram diagram, BPMNShape shape, double resolutionFactor) {
        this(el, diagram, shape, null, resolutionFactor);
    }

    public String getName() {
        String extendedName = (String)CustomElement.name.of(this.element).get();
        return extendedName.isEmpty() ? Optional.ofNullable(this.lane.getName()).orElse("") : extendedName;
    }

    @Override
    protected org.kie.workbench.common.stunner.core.graph.content.Bounds computeBounds(Bounds bounds) {
        if (this.shape == null || this.parentLaneShape == null) {
            return super.computeBounds(bounds);
        }
        Bounds parentLaneBounds = this.parentLaneShape.getBounds();
        double x = (double)parentLaneBounds.getX() * this.resolutionFactor;
        double y = (double)bounds.getY() * this.resolutionFactor;
        double width = (double)parentLaneBounds.getWidth() * this.resolutionFactor;
        double height = (double)bounds.getHeight() * this.resolutionFactor;
        return org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)x, (double)y, (double)(x + width), (double)(y + height));
    }

    @Override
    public RectangleDimensionsSet getRectangleDimensionsSet() {
        if (this.shape == null || this.parentLaneShape == null) {
            return super.getRectangleDimensionsSet();
        }
        Bounds bounds = this.shape.getBounds();
        return new RectangleDimensionsSet(Double.valueOf((double)this.parentLaneShape.getBounds().getWidth() * this.resolutionFactor), Double.valueOf((double)bounds.getHeight() * this.resolutionFactor));
    }
}

