/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.ActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.ItemNameReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class MultipleInstanceActivityPropertyReader
extends ActivityPropertyReader {
    public MultipleInstanceActivityPropertyReader(Activity activity, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super(activity, diagram, definitionResolver);
    }

    public boolean isMultipleInstance() {
        return this.getMultiInstanceLoopCharacteristics().isPresent();
    }

    public String getCollectionInput() {
        String ieDataInputId = this.getLoopDataInputRefId();
        return super.getDataInputAssociations().stream().filter(dia -> MultipleInstanceActivityPropertyReader.hasTargetRef((DataAssociation)dia, ieDataInputId)).filter(MultipleInstanceActivityPropertyReader::hasSourceRefs).map(dia -> ItemNameReader.from((ItemAwareElement)dia.getSourceRef().get(0)).getName()).findFirst().orElse(null);
    }

    public String getCollectionOutput() {
        String ieDataOutputId = this.getLoopDataOutputRefId();
        return super.getDataOutputAssociations().stream().filter(doa -> MultipleInstanceActivityPropertyReader.hasSourceRef((DataAssociation)doa, ieDataOutputId)).map(doa -> ItemNameReader.from(doa.getTargetRef()).getName()).findFirst().orElse(null);
    }

    public String getDataInput() {
        return this.getMultiInstanceLoopCharacteristics().map(MultiInstanceLoopCharacteristics::getInputDataItem).map(MultipleInstanceActivityPropertyReader::createInputVariable).orElse("");
    }

    private static String createInputVariable(DataInput input) {
        String name = input.getName() != null ? input.getName() : input.getId();
        return name + ":" + MultipleInstanceActivityPropertyReader.getVariableType((ItemAwareElement)input);
    }

    public String getDataOutput() {
        return this.getMultiInstanceLoopCharacteristics().map(MultiInstanceLoopCharacteristics::getOutputDataItem).map(MultipleInstanceActivityPropertyReader::createOutputVariable).orElse("");
    }

    private static String createOutputVariable(DataOutput output) {
        String name = output.getName() != null ? output.getName() : output.getId();
        return name + ":" + MultipleInstanceActivityPropertyReader.getVariableType((ItemAwareElement)output);
    }

    private static String getVariableType(ItemAwareElement variable) {
        String type = "";
        if (variable.getItemSubjectRef() != null) {
            type = variable.getItemSubjectRef().getStructureRef();
        }
        return StringUtils.isEmpty((String)type) ? "Object" : type;
    }

    public String getCompletionCondition() {
        return this.getMultiInstanceLoopCharacteristics().map(miloop -> (FormalExpression)miloop.getCompletionCondition()).map(fe -> FormalExpressionBodyHandler.of(fe).getBody()).orElse("");
    }

    public boolean isSequential() {
        return this.getMultiInstanceLoopCharacteristics().map(MultiInstanceLoopCharacteristics::isIsSequential).orElse(false);
    }

    private Optional<MultiInstanceLoopCharacteristics> getMultiInstanceLoopCharacteristics() {
        return Optional.ofNullable((MultiInstanceLoopCharacteristics)this.activity.getLoopCharacteristics());
    }

    @Override
    protected List<DataInput> getDataInputs() {
        if (this.getMultiInstanceLoopCharacteristics().isPresent()) {
            String dataInputIdForInputVariable = this.getDataInputIdForDataInputVariable();
            String dataInputIdForInputCollection = this.getLoopDataInputRefId();
            return super.getDataInputs().stream().filter(di -> !di.getId().equals(dataInputIdForInputVariable)).filter(di -> !di.getId().equals(dataInputIdForInputCollection)).collect(Collectors.toList());
        }
        return super.getDataInputs();
    }

    @Override
    protected List<DataOutput> getDataOutputs() {
        if (this.getMultiInstanceLoopCharacteristics().isPresent()) {
            String dataOuputIdForOutputVariable = this.getDataOutputIdForDataOutputVariable();
            String dataOutputIdForCollection = this.getLoopDataOutputRefId();
            return super.getDataOutputs().stream().filter(dout -> !dout.getId().equals(dataOuputIdForOutputVariable)).filter(dout -> !dout.getId().equals(dataOutputIdForCollection)).collect(Collectors.toList());
        }
        return super.getDataOutputs();
    }

    @Override
    protected List<DataInputAssociation> getDataInputAssociations() {
        if (this.getMultiInstanceLoopCharacteristics().isPresent()) {
            String dataInputIdForInputVariable = this.getDataInputIdForDataInputVariable();
            String dataInputIdForInputCollection = this.getLoopDataInputRefId();
            return super.getDataInputAssociations().stream().filter(dia -> !MultipleInstanceActivityPropertyReader.hasTargetRef((DataAssociation)dia, dataInputIdForInputVariable)).filter(dia -> !MultipleInstanceActivityPropertyReader.hasTargetRef((DataAssociation)dia, dataInputIdForInputCollection)).collect(Collectors.toList());
        }
        return super.getDataInputAssociations();
    }

    @Override
    protected List<DataOutputAssociation> getDataOutputAssociations() {
        if (this.getMultiInstanceLoopCharacteristics().isPresent()) {
            String dataOutputIdForOutputVariable = this.getDataOutputIdForDataOutputVariable();
            String dataOutputIdForOutputCollection = this.getLoopDataOutputRefId();
            return super.getDataOutputAssociations().stream().filter(doa -> !MultipleInstanceActivityPropertyReader.hasSourceRef((DataAssociation)doa, dataOutputIdForOutputVariable)).filter(doa -> !MultipleInstanceActivityPropertyReader.hasSourceRef((DataAssociation)doa, dataOutputIdForOutputCollection)).collect(Collectors.toList());
        }
        return super.getDataOutputAssociations();
    }

    protected String getDataInputIdForDataInputVariable() {
        String dataInputVariableId = null;
        DataInput variableDataInput = this.getMultiInstanceLoopCharacteristics().map(MultiInstanceLoopCharacteristics::getInputDataItem).orElse(null);
        if (variableDataInput != null) {
            String itemSubjectRef = MultipleInstanceActivityPropertyReader.getItemSubjectRef((ItemAwareElement)variableDataInput);
            String variableId = ItemNameReader.from((ItemAwareElement)variableDataInput).getName();
            dataInputVariableId = super.getDataInputs().stream().filter(input -> Objects.equals(variableId, input.getName())).filter(input -> MultipleInstanceActivityPropertyReader.hasItemSubjectRef((ItemAwareElement)input, itemSubjectRef)).map(BaseElement::getId).findFirst().orElse(null);
        }
        return dataInputVariableId;
    }

    protected String getDataOutputIdForDataOutputVariable() {
        String dataOutputVariableId = null;
        DataOutput variableDataOutput = this.getMultiInstanceLoopCharacteristics().map(MultiInstanceLoopCharacteristics::getOutputDataItem).orElse(null);
        if (variableDataOutput != null) {
            String itemSubjectRef = MultipleInstanceActivityPropertyReader.getItemSubjectRef((ItemAwareElement)variableDataOutput);
            String variableId = ItemNameReader.from((ItemAwareElement)variableDataOutput).getName();
            dataOutputVariableId = super.getDataOutputs().stream().filter(output -> Objects.equals(variableId, output.getName())).filter(output -> MultipleInstanceActivityPropertyReader.hasItemSubjectRef((ItemAwareElement)output, itemSubjectRef)).map(BaseElement::getId).findFirst().orElse(null);
        }
        return dataOutputVariableId;
    }

    protected String getLoopDataInputRefId() {
        return this.getMultiInstanceLoopCharacteristics().map(MultiInstanceLoopCharacteristics::getLoopDataInputRef).map(BaseElement::getId).orElse(null);
    }

    protected String getLoopDataOutputRefId() {
        return this.getMultiInstanceLoopCharacteristics().map(MultiInstanceLoopCharacteristics::getLoopDataOutputRef).map(BaseElement::getId).orElse(null);
    }

    static boolean hasSourceRefs(DataAssociation dataAssociation) {
        return dataAssociation.getSourceRef() != null && !dataAssociation.getSourceRef().isEmpty();
    }

    static boolean hasSourceRef(DataAssociation dataAssociation, String id) {
        return MultipleInstanceActivityPropertyReader.hasSourceRefs(dataAssociation) && Objects.equals(((ItemAwareElement)dataAssociation.getSourceRef().get(0)).getId(), id);
    }

    static boolean hasTargetRef(DataAssociation dataAssociation, String id) {
        return dataAssociation.getTargetRef() != null && Objects.equals(dataAssociation.getTargetRef().getId(), id);
    }

    static boolean hasItemSubjectRef(ItemAwareElement element, String itemSubjectRef) {
        return element.getItemSubjectRef() != null && Objects.equals(element.getItemSubjectRef().getId(), itemSubjectRef);
    }

    static String getItemSubjectRef(ItemAwareElement element) {
        return element.getItemSubjectRef() != null ? element.getItemSubjectRef().getId() : null;
    }
}

