/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Task;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.OnEntryScriptType;
import org.jboss.drools.OnExitScriptType;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;

public class Scripts {
    public static OnEntryAction onEntry(Task task) {
        return new OnEntryAction(Scripts.onEntry((List<ExtensionAttributeValue>)task.getExtensionValues()));
    }

    public static ScriptTypeListValue onEntry(List<ExtensionAttributeValue> extensions) {
        if (extensions.isEmpty()) {
            return new ScriptTypeListValue().addValue(new ScriptTypeValue("java", ""));
        }
        List onEntryExtensions = (List)extensions.get(0).getValue().get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, true);
        if (!onEntryExtensions.isEmpty()) {
            List scripts = onEntryExtensions.stream().map(onEntryScriptType -> new ScriptTypeValue(Scripts.scriptLanguageFromUri(onEntryScriptType.getScriptFormat()), onEntryScriptType.getScript())).collect(Collectors.toList());
            return new ScriptTypeListValue(scripts);
        }
        return new ScriptTypeListValue().addValue(new ScriptTypeValue("java", ""));
    }

    public static String scriptLanguageToUri(String language) {
        return Scripts.scriptLanguageToUri(language, LANGUAGE.JAVA.format());
    }

    public static String scriptLanguageToUri(String language, String defaultValue) {
        if (language == null) {
            return defaultValue;
        }
        if (LANGUAGE.JAVA.language().equals(language)) {
            return LANGUAGE.JAVA.format();
        }
        if (LANGUAGE.MVEL.language().equals(language)) {
            return LANGUAGE.MVEL.format();
        }
        if (LANGUAGE.JAVASCRIPT.language().equals(language)) {
            return LANGUAGE.JAVASCRIPT.format();
        }
        if (LANGUAGE.DROOLS.language().equals(language)) {
            return LANGUAGE.DROOLS.format();
        }
        if (LANGUAGE.FEEL.language().equals(language)) {
            return LANGUAGE.FEEL.format();
        }
        return defaultValue;
    }

    public static String scriptLanguageFromUri(String format) {
        return Scripts.scriptLanguageFromUri(format, null);
    }

    public static String scriptLanguageFromUri(String format, String defaultValue) {
        if (format == null) {
            return defaultValue;
        }
        if (LANGUAGE.JAVA.format().equals(format)) {
            return LANGUAGE.JAVA.language();
        }
        if (LANGUAGE.MVEL.format().equals(format)) {
            return LANGUAGE.MVEL.language();
        }
        if (LANGUAGE.JAVASCRIPT.format().equals(format)) {
            return LANGUAGE.JAVASCRIPT.language();
        }
        if (LANGUAGE.DROOLS.format().equals(format)) {
            return LANGUAGE.DROOLS.language();
        }
        if (LANGUAGE.FEEL.format().equals(format)) {
            return LANGUAGE.FEEL.language();
        }
        return defaultValue;
    }

    public static ScriptTypeListValue onExit(List<ExtensionAttributeValue> extensions) {
        if (extensions.isEmpty()) {
            return new ScriptTypeListValue().addValue(new ScriptTypeValue("java", ""));
        }
        List onExitExtensions = (List)extensions.get(0).getValue().get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, true);
        if (!onExitExtensions.isEmpty()) {
            List scripts = onExitExtensions.stream().map(onExitScriptType -> new ScriptTypeValue(Scripts.scriptLanguageFromUri(onExitScriptType.getScriptFormat()), onExitScriptType.getScript())).collect(Collectors.toList());
            return new ScriptTypeListValue(scripts);
        }
        return new ScriptTypeListValue().addValue(new ScriptTypeValue("java", ""));
    }

    public static void setOnEntryAction(FlowElement flowElement, OnEntryAction onEntryAction) {
        ScriptTypeListValue value = onEntryAction.getValue();
        for (ScriptTypeValue scriptTypeValue : value.getValues()) {
            String scriptText = scriptTypeValue.getScript();
            if (scriptText == null || scriptText.isEmpty()) continue;
            OnEntryScriptType script = Factories.droolsFactory.createOnEntryScriptType();
            script.setScript(Scripts.asCData(scriptTypeValue.getScript()));
            String scriptLanguage = Scripts.scriptLanguageToUri(scriptTypeValue.getLanguage());
            script.setScriptFormat(scriptLanguage);
            Scripts.addExtensionValue(flowElement, DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, script);
        }
    }

    public static void setOnExitAction(FlowElement flowElement, OnExitAction onExitAction) {
        ScriptTypeListValue value = onExitAction.getValue();
        for (ScriptTypeValue scriptTypeValue : value.getValues()) {
            String scriptText = scriptTypeValue.getScript();
            if (scriptText == null || scriptText.isEmpty()) continue;
            OnExitScriptType script = Factories.droolsFactory.createOnExitScriptType();
            script.setScript(Scripts.asCData(scriptText));
            String scriptLanguage = Scripts.scriptLanguageToUri(scriptTypeValue.getLanguage());
            script.setScriptFormat(scriptLanguage);
            Scripts.addExtensionValue(flowElement, DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, script);
        }
    }

    private static void addExtensionValue(FlowElement flowElement, EReference eref, Object value) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry entry = Scripts.entryOf(eref, value);
        Scripts.addExtensionValue(flowElement, (FeatureMap.Entry)entry);
    }

    private static EStructuralFeatureImpl.SimpleFeatureMapEntry entryOf(EReference eref, Object script) {
        return new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)eref, script);
    }

    private static void addExtensionValue(FlowElement flowElement, FeatureMap.Entry value) {
        Scripts.extensionFor(flowElement).getValue().add((Object)value);
    }

    private static ExtensionAttributeValue extensionFor(FlowElement flowElement) {
        if (flowElement.getExtensionValues() == null || flowElement.getExtensionValues().isEmpty()) {
            ExtensionAttributeValue eav = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
            flowElement.getExtensionValues().add((Object)eav);
            return eav;
        }
        return (ExtensionAttributeValue)flowElement.getExtensionValues().get(0);
    }

    public static String asCData(String original) {
        return "<![CDATA[" + original + "]]>";
    }

    public static enum LANGUAGE {
        JAVA("java", "http://www.java.com/java"),
        JAVASCRIPT("javascript", "http://www.javascript.com/javascript"),
        MVEL("mvel", "http://www.mvel.org/2.0"),
        DROOLS("drools", "http://www.jboss.org/drools/rule"),
        FEEL("feel", "http://www.omg.org/spec/FEEL/20140401");

        private final String language;
        private final String format;

        private LANGUAGE(String language, String format) {
            this.language = language;
            this.format = format;
        }

        public String language() {
            return this.language;
        }

        public String format() {
            return this.format;
        }
    }
}

