/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.List;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.EdgePropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.FlowElementPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.util.PropertyReaderUtils;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class SequenceFlowPropertyReader
extends FlowElementPropertyReader
implements EdgePropertyReader {
    private final DefinitionResolver definitionResolver;
    private final SequenceFlow seq;

    public SequenceFlowPropertyReader(SequenceFlow seq, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((FlowElement)seq, diagram, definitionResolver.getShape(seq.getId()), definitionResolver.getResolutionFactor());
        this.seq = seq;
        this.definitionResolver = definitionResolver;
    }

    public String getPriority() {
        return CustomAttribute.priority.of(this.element).get();
    }

    public ScriptTypeValue getConditionExpression() {
        if (this.seq.getConditionExpression() instanceof FormalExpression) {
            FormalExpression conditionExpression = (FormalExpression)this.seq.getConditionExpression();
            return new ScriptTypeValue(Scripts.scriptLanguageFromUri(conditionExpression.getLanguage()), FormalExpressionBodyHandler.of(conditionExpression).getBody());
        }
        return new ScriptTypeValue("java", "");
    }

    @Override
    public String getSourceId() {
        return this.seq.getSourceRef().getId();
    }

    @Override
    public String getTargetId() {
        return this.seq.getTargetRef().getId();
    }

    @Override
    public Connection getSourceConnection() {
        Point2D sourcePosition = PropertyReaderUtils.getSourcePosition(this.definitionResolver, this.element.getId(), this.getSourceId());
        return MagnetConnection.Builder.at((double)sourcePosition.getX(), (double)sourcePosition.getY()).setAuto(PropertyReaderUtils.isAutoConnectionSource(this.element));
    }

    @Override
    public Connection getTargetConnection() {
        Point2D targetPosition = PropertyReaderUtils.getTargetPosition(this.definitionResolver, this.element.getId(), this.getTargetId());
        return MagnetConnection.Builder.at((double)targetPosition.getX(), (double)targetPosition.getY()).setAuto(PropertyReaderUtils.isAutoConnectionTarget(this.element));
    }

    @Override
    public List<Point2D> getControlPoints() {
        return PropertyReaderUtils.getControlPoints(this.definitionResolver, this.element.getId());
    }

    @Override
    public DefinitionResolver getDefinitionResolver() {
        return this.definitionResolver;
    }
}

