/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.ParameterValue;
import bpsim.PoissonDistributionType;
import bpsim.ResourceParameters;
import bpsim.TimeParameters;
import bpsim.UniformDistributionType;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Match;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;

public class SimulationSets {
    public static ElementParameters toElementParameters(SimulationSet simulationSet) {
        ElementParameters elementParameters = Factories.bpsim.createElementParameters();
        TimeParameters timeParameters = Factories.bpsim.createTimeParameters();
        Parameter processingTime = Factories.bpsim.createParameter();
        timeParameters.setProcessingTime(processingTime);
        switch (simulationSet.getDistributionType().getValue()) {
            case "normal": {
                NormalDistributionType ndt = Factories.bpsim.createNormalDistributionType();
                ndt.setMean(simulationSet.getMean().getValue().doubleValue());
                ndt.setStandardDeviation(simulationSet.getStandardDeviation().getValue().doubleValue());
                processingTime.getParameterValue().add((Object)ndt);
                break;
            }
            case "uniform": {
                UniformDistributionType udt = Factories.bpsim.createUniformDistributionType();
                udt.setMin(simulationSet.getMin().getValue().doubleValue());
                udt.setMax(simulationSet.getMax().getValue().doubleValue());
                processingTime.getParameterValue().add((Object)udt);
                break;
            }
            case "poisson": {
                PoissonDistributionType pdt = Factories.bpsim.createPoissonDistributionType();
                pdt.setMean(simulationSet.getMean().getValue().doubleValue());
                processingTime.getParameterValue().add((Object)pdt);
            }
        }
        elementParameters.setTimeParameters(timeParameters);
        Double unitCost = simulationSet.getUnitCost().getValue();
        Double quantity = simulationSet.getQuantity().getValue();
        Double workingHours = simulationSet.getWorkingHours().getValue();
        CostParameters costParameters = Factories.bpsim.createCostParameters();
        costParameters.setUnitCost(SimulationSets.toParameter(unitCost));
        elementParameters.setCostParameters(costParameters);
        ResourceParameters resourceParameters = Factories.bpsim.createResourceParameters();
        resourceParameters.setQuantity(SimulationSets.toParameter(quantity));
        resourceParameters.setAvailability(SimulationSets.toParameter(workingHours));
        elementParameters.setResourceParameters(resourceParameters);
        return elementParameters;
    }

    private static Parameter toParameter(Double value) {
        Parameter parameter = Factories.bpsim.createParameter();
        FloatingParameterType parameterValue = Factories.bpsim.createFloatingParameterType();
        parameterValue.setValue(value.doubleValue());
        parameter.getParameterValue().add((Object)parameterValue);
        return parameter;
    }

    public static SimulationSet of(ElementParameters eleType) {
        ResourceParameters resourceParams;
        TimeParameters timeParams = eleType.getTimeParameters();
        if (timeParams == null) {
            return new SimulationSet();
        }
        Parameter processingTime = timeParams.getProcessingTime();
        ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
        SimulationSet simulationSet = Match.of().when(e -> e instanceof NormalDistributionType, ndt -> {
            SimulationSet sset = new SimulationSet();
            sset.getMean().setValue(Double.valueOf(ndt.getMean()));
            sset.getStandardDeviation().setValue(Double.valueOf(ndt.getStandardDeviation()));
            sset.getDistributionType().setValue("normal");
            return sset;
        }).when(e -> e instanceof UniformDistributionType, udt -> {
            SimulationSet sset = new SimulationSet();
            sset.getMin().setValue(Double.valueOf(udt.getMin()));
            sset.getMax().setValue(Double.valueOf(udt.getMax()));
            sset.getDistributionType().setValue("uniform");
            return sset;
        }).when(e -> e instanceof PoissonDistributionType, pdt -> {
            SimulationSet sset = new SimulationSet();
            sset.getMean().setValue(Double.valueOf(pdt.getMean()));
            sset.getDistributionType().setValue("poisson");
            return sset;
        }).apply(paramValue).asSuccess().value();
        CostParameters costParams = eleType.getCostParameters();
        if (costParams != null) {
            simulationSet.getUnitCost().setValue(SimulationSets.extractDouble(costParams.getUnitCost()));
        }
        if ((resourceParams = eleType.getResourceParameters()) != null) {
            Double quantity = SimulationSets.extractDouble(resourceParams.getQuantity());
            simulationSet.getQuantity().setValue(quantity);
            Double availability = SimulationSets.extractDouble(resourceParams.getAvailability());
            simulationSet.getWorkingHours().setValue(availability);
        }
        return simulationSet;
    }

    private static Double extractDouble(Parameter parameter) {
        if (parameter == null) {
            return 0.0;
        }
        return SimulationSets.extractDouble((EList<ParameterValue>)parameter.getParameterValue());
    }

    private static Double extractDouble(EList<ParameterValue> parameterValues) {
        if (parameterValues.isEmpty()) {
            throw new IllegalArgumentException("failure params");
        }
        ParameterValue value = (ParameterValue)parameterValues.get(0);
        FloatingParameterType floatingValue = (FloatingParameterType)value;
        return floatingValue.getValue();
    }
}

