/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class PropertyReaderUtils {
    public static Point2D getSourcePosition(DefinitionResolver definitionResolver, String edgeId, String sourceId) {
        double resolutionFactor = definitionResolver.getResolutionFactor();
        Bounds sourceBounds = definitionResolver.getShape(sourceId).getBounds();
        EList waypoint = definitionResolver.getEdge(edgeId).getWaypoint();
        return waypoint.isEmpty() ? PropertyReaderUtils.sourcePosition(sourceBounds, resolutionFactor) : PropertyReaderUtils.offsetPosition(sourceBounds, (Point)waypoint.get(0), resolutionFactor);
    }

    public static Point2D getTargetPosition(DefinitionResolver definitionResolver, String edgeId, String targetId) {
        double resolutionFactor = definitionResolver.getResolutionFactor();
        Bounds targetBounds = definitionResolver.getShape(targetId).getBounds();
        EList waypoint = definitionResolver.getEdge(edgeId).getWaypoint();
        return waypoint.isEmpty() ? PropertyReaderUtils.targetPosition(targetBounds, resolutionFactor) : PropertyReaderUtils.offsetPosition(targetBounds, (Point)waypoint.get(waypoint.size() - 1), resolutionFactor);
    }

    public static List<Point2D> getControlPoints(DefinitionResolver definitionResolver, String edgeId) {
        double resolutionFactor = definitionResolver.getResolutionFactor();
        EList waypoint = definitionResolver.getEdge(edgeId).getWaypoint();
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        if (waypoint.size() > 2) {
            List points = waypoint.subList(1, waypoint.size() - 1);
            for (Point p : points) {
                result.add(PropertyReaderUtils.createPoint2D(p, resolutionFactor));
            }
        }
        return result;
    }

    private static Point2D createPoint2D(Point p, double factor) {
        return Point2D.create((double)((double)p.getX() * factor), (double)((double)p.getY() * factor));
    }

    public static boolean isAutoConnectionSource(BaseElement element) {
        return (Boolean)CustomElement.autoConnectionSource.of(element).get();
    }

    public static boolean isAutoConnectionTarget(BaseElement element) {
        return (Boolean)CustomElement.autoConnectionTarget.of(element).get();
    }

    private static Point2D sourcePosition(Bounds sourceBounds, double factor) {
        return Point2D.create((double)((double)sourceBounds.getWidth() * factor), (double)((double)sourceBounds.getHeight() * factor / 2.0));
    }

    private static Point2D targetPosition(Bounds targetBounds, double factor) {
        return Point2D.create((double)0.0, (double)((double)targetBounds.getHeight() * factor / 2.0));
    }

    private static Point2D offsetPosition(Bounds sourceBounds, Point wayPoint, double factor) {
        return Point2D.create((double)((double)wayPoint.getX() * factor - (double)sourceBounds.getX() * factor), (double)((double)wayPoint.getY() * factor - (double)sourceBounds.getY() * factor));
    }
}

