/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.service;

import elemental2.promise.Promise;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.ConverterUtils;
import org.kie.workbench.common.stunner.bpmn.client.marshall.service.BPMNClientMarshalling;
import org.kie.workbench.common.stunner.bpmn.client.workitem.WorkItemDefinitionClientService;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.BaseDiagramSet;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNDiagramFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.kogito.api.editor.DiagramType;
import org.kie.workbench.common.stunner.kogito.api.editor.impl.KogitoDiagramResourceImpl;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;

@ApplicationScoped
public class BPMNClientDiagramService
implements KogitoClientDiagramService {
    static final String DEFAULT_PROCESS_ID = "default";
    private final DefinitionManager definitionManager;
    private final BPMNClientMarshalling marshalling;
    private final FactoryManager factoryManager;
    private final BPMNDiagramFactory diagramFactory;
    private final ShapeManager shapeManager;
    private final Promises promises;
    private final WorkItemDefinitionClientService widService;
    private static final String ROOT_PATH = "default://master@system/stunner/diagrams";

    protected BPMNClientDiagramService() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public BPMNClientDiagramService(DefinitionManager definitionManager, BPMNClientMarshalling marshalling, FactoryManager factoryManager, BPMNDiagramFactory diagramFactory, ShapeManager shapeManager, Promises promises, WorkItemDefinitionClientService widService) {
        this.definitionManager = definitionManager;
        this.marshalling = marshalling;
        this.factoryManager = factoryManager;
        this.diagramFactory = diagramFactory;
        this.shapeManager = shapeManager;
        this.promises = promises;
        this.widService = widService;
    }

    public void transform(String xml, ServiceCallback<Diagram> callback) {
        this.doTransform(DEFAULT_PROCESS_ID, xml, callback);
    }

    public void transform(String fileName, String xml, ServiceCallback<Diagram> callback) {
        this.doTransform(fileName, xml, callback);
    }

    public Promise<String> transform(KogitoDiagramResourceImpl resource) {
        if (resource.getType() == DiagramType.PROJECT_DIAGRAM) {
            return this.promises.resolve((Object)this.transform((Diagram)resource.projectDiagram().orElseThrow(() -> new IllegalStateException("DiagramType is PROJECT_DIAGRAM however no instance present"))));
        }
        return this.promises.resolve((Object)resource.xmlDiagram().orElse("DiagramType is XML_DIAGRAM however no instance present"));
    }

    private void doTransform(String fileName, String xml, ServiceCallback<Diagram> callback) {
        Metadata metadata = this.createMetadata();
        this.widService.call((Object)metadata).then(wid -> {
            Diagram diagram = this.doTransform(fileName, xml);
            callback.onSuccess((Object)diagram);
            return this.promises.resolve();
        }).catch_(error -> {
            callback.onError(new ClientRuntimeError(error.toString()));
            return this.promises.resolve();
        });
    }

    private Diagram doTransform(String fileName, String xml) {
        if (Objects.isNull(xml) || xml.isEmpty()) {
            return this.createNewDiagram();
        }
        return this.parse(fileName, xml);
    }

    public String transform(Diagram diagram) {
        return this.marshalling.marshall((Diagram<Graph, Metadata>)this.convert(diagram));
    }

    private Diagram createNewDiagram() {
        String title = DEFAULT_PROCESS_ID;
        String defSetId = BPMNClientMarshalling.getDefinitionSetId();
        Metadata metadata = this.createMetadata();
        metadata.setTitle(DEFAULT_PROCESS_ID);
        Diagram diagram = this.factoryManager.newDiagram(DEFAULT_PROCESS_ID, defSetId, metadata);
        this.updateClientMetadata(diagram);
        return diagram;
    }

    private Diagram parse(String fileName, String raw) {
        Metadata metadata = this.createMetadata();
        Graph<DefinitionSet, Node> graph = this.marshalling.unmarshall(metadata, raw);
        Node diagramNode = GraphUtils.getFirstNode(graph, BPMNDiagramImpl.class);
        if (null == diagramNode) {
            throw new RuntimeException("No BPMN Diagram can be found.");
        }
        BaseDiagramSet diagramSet = ((BPMNDiagram)((Definition)diagramNode.getContent()).getDefinition()).getDiagramSet();
        if (diagramSet.getName().getValue().isEmpty()) {
            diagramSet.getName().setValue(fileName);
        }
        if (diagramSet.getId().getValue().isEmpty()) {
            diagramSet.getId().setValue(fileName);
        }
        String title = ((BPMNDiagram)((Definition)diagramNode.getContent()).getDefinition()).getDiagramSet().getName().getValue();
        metadata.setTitle(title);
        Diagram diagram = this.diagramFactory.build(title, metadata, graph);
        this.updateClientMetadata(diagram);
        return diagram;
    }

    private Metadata createMetadata() {
        return new MetadataImpl.MetadataImplBuilder(BPMNClientMarshalling.getDefinitionSetId(), this.definitionManager).setRoot(PathFactory.newPath((String)".", (String)ROOT_PATH)).build();
    }

    private void updateClientMetadata(Diagram diagram) {
        Metadata metadata;
        if (null != diagram && Objects.nonNull(metadata = diagram.getMetadata()) && ConverterUtils.isEmpty(metadata.getShapeSetId())) {
            String sId = this.shapeManager.getDefaultShapeSet(metadata.getDefinitionSetId()).getId();
            metadata.setShapeSetId(sId);
        }
    }

    private DiagramImpl convert(Diagram diagram) {
        return new DiagramImpl(diagram.getName(), diagram.getGraph(), diagram.getMetadata());
    }
}

