/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.service;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.client.emf.Bpmn2Marshalling;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingRequest;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.DefinitionsConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.GraphBuilder;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleManager;

@ApplicationScoped
public class BPMNClientMarshalling {
    private static Logger LOGGER = Logger.getLogger(BPMNClientMarshalling.class.getName());
    private final DefinitionManager definitionManager;
    private final RuleManager ruleManager;
    private final TypedFactoryManager typedFactoryManager;
    private final GraphCommandFactory commandFactory;
    private final GraphCommandManager commandManager;
    private final ManagedInstance<WorkItemDefinitionRegistry> widRegistries;

    @Inject
    public BPMNClientMarshalling(DefinitionManager definitionManager, RuleManager ruleManager, FactoryManager factoryManager, GraphCommandFactory commandFactory, GraphCommandManager commandManager, ManagedInstance<WorkItemDefinitionRegistry> widRegistries) {
        this.definitionManager = definitionManager;
        this.ruleManager = ruleManager;
        this.typedFactoryManager = new TypedFactoryManager(factoryManager);
        this.commandFactory = commandFactory;
        this.commandManager = commandManager;
        this.widRegistries = widRegistries;
    }

    @PostConstruct
    public void init() {
        Bpmn2Marshalling.setLogger(message -> LOGGER.log(Level.SEVERE, (String)message));
    }

    public String marshall(Diagram<Graph, Metadata> diagram) {
        PropertyWriterFactory propertyWriterFactory = new PropertyWriterFactory();
        DefinitionsBuildingContext buildingContext = new DefinitionsBuildingContext((Graph<DefinitionSet, Node<View<? extends BPMNViewDefinition>, Edge<ViewConnector<BPMNViewDefinition>, Node<? extends View<? extends BPMNViewDefinition>, ?>>>>)diagram.getGraph(), BPMNClientMarshalling.getDiagramClass());
        ConverterFactory converterFactory = new ConverterFactory(buildingContext, propertyWriterFactory);
        DefinitionsConverter definitionsConverter = new DefinitionsConverter(converterFactory, propertyWriterFactory);
        Definitions definitions = definitionsConverter.toDefinitions();
        return Bpmn2Marshalling.marshall((Definitions)definitions);
    }

    public Graph<DefinitionSet, Node> unmarshall(Metadata metadata, String raw) {
        MarshallingRequest.Mode mode = MarshallingRequest.Mode.AUTO;
        Graph<DefinitionSet, Node> graph = this.unmarshall(metadata, mode, raw);
        return graph;
    }

    private Graph<DefinitionSet, Node> unmarshall(Metadata metadata, MarshallingRequest.Mode mode, String raw) {
        DocumentRoot documentRoot = Bpmn2Marshalling.unmarshall((String)raw);
        DefinitionsHandler definitionsHandler = new DefinitionsHandler(documentRoot);
        DefinitionResolver definitionResolver = new DefinitionResolver(definitionsHandler.getDefinitions(), this.getWorkItemDefinitions(), definitionsHandler.isJbpm(), mode);
        metadata.setCanvasRootUUID(definitionResolver.getDefinitions().getId());
        metadata.setTitle(definitionResolver.getProcess().getName());
        org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.ConverterFactory converterFactory = new org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.ConverterFactory(definitionResolver, this.typedFactoryManager);
        Result<BpmnNode> result = ((BaseConverterFactory)converterFactory).rootProcessConverter().convertProcess();
        BpmnNode diagramRoot = result.value();
        Diagram<Graph<DefinitionSet, Node>, Metadata> diagram = this.typedFactoryManager.newDiagram(definitionResolver.getDefinitions().getId(), BPMNClientMarshalling.getDefinitionSetClass(), metadata);
        Graph graph = diagram.getGraph();
        GraphBuilder graphBuilder = new GraphBuilder((Graph<DefinitionSet, Node>)graph, this.definitionManager, this.typedFactoryManager, this.ruleManager, this.commandFactory, this.commandManager);
        graphBuilder.render(diagramRoot);
        return graph;
    }

    private Collection<WorkItemDefinition> getWorkItemDefinitions() {
        return ((WorkItemDefinitionRegistry)this.widRegistries.get()).items();
    }

    public static Class<?> getDiagramClass() {
        return BPMNDiagramImpl.class;
    }

    public static String getDefinitionSetId() {
        return BindableAdapterUtils.getDefinitionSetId(BPMNClientMarshalling.getDefinitionSetClass());
    }

    public static Class<?> getDefinitionSetClass() {
        return BPMNDefinitionSet.class;
    }

    static class DefinitionsHandler {
        private static final String JBPM_PREFIX = "jBPM";
        private static final String DROOLS_NAMESPACE = "http://www.jboss.org/drools";
        private final Definitions definitions;
        private final boolean jbpm;

        DefinitionsHandler(DocumentRoot root) {
            this.definitions = root.getDefinitions();
            this.jbpm = DefinitionsHandler.isJbpmnDocument(root, this.definitions);
        }

        public Definitions getDefinitions() {
            return this.definitions;
        }

        public boolean isJbpm() {
            return this.jbpm;
        }

        private static boolean isJbpmnDocument(DocumentRoot root, Definitions definitions) {
            String exporter = definitions.getExporter();
            if (exporter != null) {
                return exporter.toLowerCase().startsWith(JBPM_PREFIX.toLowerCase());
            }
            return root.getXMLNSPrefixMap().values().contains(DROOLS_NAMESPACE) || root.getXSISchemaLocation().keySet().contains(DROOLS_NAMESPACE);
        }
    }
}

