/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;

public class TestDefinitionsWriter {
    private final DefinitionResolver definitionResolver;
    private BPMNPlane bpmnPlane;

    public TestDefinitionsWriter() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add((Object)Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        this.bpmnPlane = Factories.di.createBPMNPlane();
        bpmnDiagram.setPlane(this.bpmnPlane);
        definitions.getDiagrams().add((Object)bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
    }

    public DefinitionResolver getDefinitionResolver() {
        return this.definitionResolver;
    }

    public FlowNode mockNode(String id, Bounds bounds) {
        Task node = Factories.bpmn2.createTask();
        node.setId(id);
        BPMNShape shape = Factories.di.createBPMNShape();
        shape.setBounds(bounds);
        shape.setBpmnElement((BaseElement)node);
        this.bpmnPlane.getPlaneElement().add((Object)shape);
        return node;
    }

    public SequenceFlow sequenceFlowOf(String id, FlowNode source, FlowNode target, List<Point> waypoints) {
        SequenceFlow sequenceFlow = Factories.bpmn2.createSequenceFlow();
        sequenceFlow.setId(id);
        sequenceFlow.setSourceRef(source);
        sequenceFlow.setTargetRef(target);
        BPMNEdge edge = Factories.di.createBPMNEdge();
        edge.setBpmnElement((BaseElement)sequenceFlow);
        this.bpmnPlane.getPlaneElement().add((Object)edge);
        edge.getWaypoint().addAll(waypoints);
        return sequenceFlow;
    }
}

