/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.VariableDeclaration;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class VariableDeclarationTest {
    private static final String CONSTRUCTOR_IDENTIFIER = "Variable Declaration Test";
    private static final String CONSTRUCTOR_TYPE = "Integer";
    private static final String CONSTRUCTOR_TAGS = "[input;customTag]";
    private static final String VAR_IDENTIFIER = "Variable-Declaration-Test";
    private static final String VAR_NAME = "Variable Declaration Test";
    private static final String VAR_TAGS = "[internal;input;customTag]";
    private VariableDeclaration tested;

    @Before
    public void setup() {
        this.tested = new VariableDeclaration("Variable Declaration Test", CONSTRUCTOR_TYPE, CONSTRUCTOR_TAGS);
    }

    @Test
    public void testIdentifier() {
        String identifier = this.tested.getIdentifier();
        Assert.assertEquals((Object)identifier, (Object)VAR_IDENTIFIER);
    }

    @Test
    public void testName() {
        String name = this.tested.getTypedIdentifier().getName();
        Assert.assertEquals((Object)name, (Object)"Variable Declaration Test");
    }

    @Test
    public void testTags() {
        String tags = this.tested.getTags();
        Assert.assertEquals((Object)CONSTRUCTOR_TAGS, (Object)tags);
    }

    @Test
    public void testEquals() {
        VariableDeclaration comparable = new VariableDeclaration("Variable Declaration Test", CONSTRUCTOR_TYPE, CONSTRUCTOR_TAGS);
        Assert.assertEquals((Object)this.tested, (Object)comparable);
    }

    @Test
    public void testNotEquals() {
        VariableDeclaration comparable = new VariableDeclaration("Variable Declaration Test", CONSTRUCTOR_TYPE, "[input;customTagX]");
        Assert.assertNotEquals((Object)this.tested, (Object)comparable);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)this.tested.toString(), (Object)"Variable Declaration Test:Integer:[input;customTag]");
        Assert.assertNotEquals((Object)this.tested.toString(), (Object)"Variable Declaration Test:Integer:[myCustomTag]");
        VariableDeclaration comparable = new VariableDeclaration("Variable Declaration Test", CONSTRUCTOR_TYPE, null);
        Assert.assertEquals((Object)comparable.toString(), (Object)"Variable Declaration Test:Integer");
        comparable = new VariableDeclaration("Variable Declaration Test", CONSTRUCTOR_TYPE, "");
        Assert.assertEquals((Object)comparable.toString(), (Object)"Variable Declaration Test:Integer");
    }
}

