/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.associations;

import java.util.ArrayList;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.emf.common.util.ECollections;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.associations.AbstractCompensationEventPostConverterTest;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.ActivityRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractThrowCompensationEventPostConverterTest<T extends BPMNViewDefinition>
extends AbstractCompensationEventPostConverterTest<T, ThrowEvent> {
    protected static final String ACTIVITY_REF = "ACTIVITY_REF";
    @Mock
    protected ActivityRef activityRef;
    @Mock
    protected Activity activity;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.getExecutionSet(this.event).getActivityRef().setValue(ACTIVITY_REF);
        Mockito.when((Object)this.activity.getId()).thenReturn((Object)ACTIVITY_REF);
    }

    @Override
    public ThrowEvent createBpmn2Event(CompensateEventDefinition compensateEvent) {
        ThrowEvent throwEvent = (ThrowEvent)Mockito.mock(ThrowEvent.class);
        Mockito.when((Object)throwEvent.getEventDefinitions()).thenReturn((Object)ECollections.singletonEList((Object)compensateEvent));
        return throwEvent;
    }

    public abstract CompensationEventExecutionSet getExecutionSet(T var1);

    @Test
    public void testProcessWhenActivityFound() {
        Mockito.when((Object)this.process.getFlowElements()).thenReturn((Object)ECollections.singletonEList((Object)this.activity));
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((CompensateEventDefinition)Mockito.verify((Object)this.compensateEvent)).setActivityRef(this.activity);
    }

    @Test
    public void testProcessWhenActivityNotFound() {
        ArrayList flowElements = new ArrayList();
        Mockito.when((Object)this.process.getFlowElements()).thenReturn((Object)ECollections.emptyEList());
        this.converter.process(this.processWriter, this.nodeWriter, this.node);
        ((CompensateEventDefinition)Mockito.verify((Object)this.compensateEvent, (VerificationMode)Mockito.never())).setActivityRef(this.activity);
    }
}

