/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.gateways;

import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.Gateway;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TestUtils;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.gateways.GatewayConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.GatewayPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.EventGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.InclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ParallelGateway;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GatewayConverterTest {
    private static final String UUID = "UUID";
    private static final String DEFAULT_ROUTE = "DEFAULT_ROUTE";
    private static final String NAME = "NAME";
    private static final String DOCUMENTATION = "DOCUMENTATION";
    @Mock
    private PropertyWriterFactory propertyWriterFactory;
    @Mock
    private GatewayPropertyWriter gatewayPropertyWriter;
    private GatewayConverter converter;

    @Before
    public void setUp() {
        this.converter = new GatewayConverter(this.propertyWriterFactory);
    }

    @Test
    public void testInclusive() {
        InclusiveGateway gateway = new InclusiveGateway();
        gateway.getGeneral().getName().setValue(NAME);
        gateway.getGeneral().getDocumentation().setValue(DOCUMENTATION);
        gateway.getExecutionSet().getDefaultRoute().setValue(DEFAULT_ROUTE);
        Node<View<InclusiveGateway>, ?> node = TestUtils.newNode(UUID, gateway);
        Mockito.when((Object)this.propertyWriterFactory.of((Gateway)Matchers.any(org.eclipse.bpmn2.InclusiveGateway.class))).thenReturn((Object)this.gatewayPropertyWriter);
        Assert.assertEquals((Object)this.gatewayPropertyWriter, (Object)this.converter.toFlowElement(node));
        this.verifyCommonValues((PropertyWriter)this.gatewayPropertyWriter, node);
        ((GatewayPropertyWriter)Mockito.verify((Object)this.gatewayPropertyWriter)).setDefaultRoute(DEFAULT_ROUTE);
        ((GatewayPropertyWriter)Mockito.verify((Object)this.gatewayPropertyWriter)).setGatewayDirection(node);
    }

    @Test
    public void testExclusive() {
        ExclusiveGateway gateway = new ExclusiveGateway();
        gateway.getGeneral().getName().setValue(NAME);
        gateway.getGeneral().getDocumentation().setValue(DOCUMENTATION);
        gateway.getExecutionSet().getDefaultRoute().setValue(DEFAULT_ROUTE);
        Node<View<ExclusiveGateway>, ?> node = TestUtils.newNode(UUID, gateway);
        Mockito.when((Object)this.propertyWriterFactory.of((Gateway)Matchers.any(org.eclipse.bpmn2.ExclusiveGateway.class))).thenReturn((Object)this.gatewayPropertyWriter);
        Assert.assertEquals((Object)this.gatewayPropertyWriter, (Object)this.converter.toFlowElement(node));
        this.verifyCommonValues((PropertyWriter)this.gatewayPropertyWriter, node);
        ((GatewayPropertyWriter)Mockito.verify((Object)this.gatewayPropertyWriter)).setDefaultRoute(DEFAULT_ROUTE);
        ((GatewayPropertyWriter)Mockito.verify((Object)this.gatewayPropertyWriter)).setGatewayDirection(node);
    }

    @Test
    public void testParallel() {
        ParallelGateway gateway = new ParallelGateway();
        gateway.getGeneral().getName().setValue(NAME);
        gateway.getGeneral().getDocumentation().setValue(DOCUMENTATION);
        Node<View<ParallelGateway>, ?> node = TestUtils.newNode(UUID, gateway);
        Mockito.when((Object)this.propertyWriterFactory.of((Gateway)Matchers.any(org.eclipse.bpmn2.ParallelGateway.class))).thenReturn((Object)this.gatewayPropertyWriter);
        Assert.assertEquals((Object)this.gatewayPropertyWriter, (Object)this.converter.toFlowElement(node));
        this.verifyCommonValues((PropertyWriter)this.gatewayPropertyWriter, node);
        ((GatewayPropertyWriter)Mockito.verify((Object)this.gatewayPropertyWriter)).setGatewayDirection(node);
    }

    @Test
    public void testEvent() {
        EventGateway gateway = new EventGateway();
        gateway.getGeneral().getName().setValue(NAME);
        gateway.getGeneral().getDocumentation().setValue(DOCUMENTATION);
        Node<View<EventGateway>, ?> node = TestUtils.newNode(UUID, gateway);
        Mockito.when((Object)this.propertyWriterFactory.of((Gateway)Matchers.any(EventBasedGateway.class))).thenReturn((Object)this.gatewayPropertyWriter);
        Assert.assertEquals((Object)this.gatewayPropertyWriter, (Object)this.converter.toFlowElement(node));
        this.verifyCommonValues((PropertyWriter)this.gatewayPropertyWriter, node);
    }

    private void verifyCommonValues(PropertyWriter propertyWriter, Node node) {
        ((PropertyWriter)Mockito.verify((Object)propertyWriter)).setId(UUID);
        ((PropertyWriter)Mockito.verify((Object)propertyWriter)).setName(NAME);
        ((PropertyWriter)Mockito.verify((Object)propertyWriter)).setDocumentation(DOCUMENTATION);
        ((PropertyWriter)Mockito.verify((Object)propertyWriter)).setAbsoluteBounds(node);
    }
}

