/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.processes;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.di.BPMNShape;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.processes.SubProcessConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.AdHocSubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.SubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.DocumentationTextHandler;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;
import org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocAutostart;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.mockito.Mockito;
import org.uberfire.commons.data.Pair;

public class SubProcessConverterTest {
    private static final String ELEMENT_ID = "ELEMENT_ID";
    private static final String NAME = "NAME";
    private static final String DOCUMENTATION = "DOCUMENTATION";
    private static final String ACTIVATION_CONDITION = "ACTIVATION_CONDITION";
    private static final ScriptTypeValue COMPLETION_CONDITION = new ScriptTypeValue("drools", "the condition");
    private static final ScriptTypeValue ON_ENTRY_ACTION = new ScriptTypeValue("java", "on entry script");
    private static final ScriptTypeValue ON_EXIT_ACTION = new ScriptTypeValue("java", "on exit script");
    private static final String SLA_DUE_DATE = "12/25/1983";
    private SubProcessConverter tested;

    @Test
    public void JBPM_7525_eventSubProcessShouldStoreIsAsync() {
        ConverterFactory f = new ConverterFactory(new DefinitionsBuildingContext((Graph)new GraphImpl("x", (GraphNodeStore)new GraphNodeStoreImpl())), new PropertyWriterFactory());
        SubProcessConverter c = f.subProcessConverter();
        NodeImpl n = new NodeImpl("n");
        EventSubprocess subProcessNode = new EventSubprocess();
        subProcessNode.getExecutionSet().setIsAsync(new IsAsync(Boolean.valueOf(true)));
        n.setContent((Object)new ViewImpl((Object)subProcessNode, Bounds.create()));
        Activity activity = ((SubProcessPropertyWriter)c.convertSubProcess((Node)n).value()).getFlowElement();
        Boolean value = (Boolean)CustomElement.async.of((BaseElement)activity).get();
        Assertions.assertThat((Boolean)value).isEqualTo(true);
    }

    @Before
    public void setUp() {
        PropertyWriterFactory factory = new PropertyWriterFactory();
        DefinitionsBuildingContext definitionsBuildingContext = new DefinitionsBuildingContext((Graph)new GraphImpl("x", (GraphNodeStore)new GraphNodeStoreImpl()));
        this.tested = new SubProcessConverter(definitionsBuildingContext, factory, new ConverterFactory(definitionsBuildingContext, factory));
    }

    @Test
    public void testConvertAdHocSubprocessNode_autostart() {
        AdHocSubprocess definition = new AdHocSubprocess();
        definition.getExecutionSet().setAdHocAutostart(new AdHocAutostart(Boolean.valueOf(true)));
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(UUID.randomUUID().toString());
        node.setContent((Object)view);
        SubProcessPropertyWriter writer = this.tested.convertAdHocSubprocessNode((Node)node);
        Assert.assertTrue((boolean)AdHocSubProcessPropertyWriter.class.isInstance(writer));
        Assert.assertTrue((boolean)((Boolean)CustomElement.autoStart.of((BaseElement)writer.getFlowElement()).get()));
    }

    @Test
    public void testConvertAdHocSubprocessNode_notautostart() {
        AdHocSubprocess definition = new AdHocSubprocess();
        definition.getExecutionSet().setAdHocAutostart(new AdHocAutostart(Boolean.valueOf(false)));
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(UUID.randomUUID().toString());
        node.setContent((Object)view);
        SubProcessPropertyWriter writer = this.tested.convertAdHocSubprocessNode((Node)node);
        Assert.assertTrue((boolean)AdHocSubProcessPropertyWriter.class.isInstance(writer));
        Assert.assertFalse((boolean)((Boolean)CustomElement.autoStart.of((BaseElement)writer.getFlowElement()).get()));
    }

    private static void setBaseSubprocessExecutionSetValues(BaseSubprocessTaskExecutionSet executionSet) {
        executionSet.setIsAsync(new IsAsync(Boolean.TRUE));
        executionSet.setSlaDueDate(new SLADueDate(SLA_DUE_DATE));
    }

    private static void assertBaseSubprocessExecutionSet(SubProcessPropertyWriter writer) {
        Assert.assertTrue((boolean)SubProcessPropertyWriter.class.isInstance(writer));
        Assert.assertTrue((boolean)((Boolean)CustomElement.async.of(writer.getElement()).get()));
        Assert.assertTrue((boolean)((String)CustomElement.slaDueDate.of(writer.getElement()).get()).contains(SLA_DUE_DATE));
    }

    @Test
    public void testConvertAdhocSubprocess() {
        AdHocSubprocess definition = new AdHocSubprocess();
        String adHocOrdering = "Parallel";
        boolean adHocAutostart = true;
        String processVariables = "processVar1:Object:myTag,processVar2:Integer";
        definition.getGeneral().getName().setValue(NAME);
        definition.getGeneral().getDocumentation().setValue(DOCUMENTATION);
        definition.getProcessData().getProcessVariables().setValue(processVariables);
        definition.getExecutionSet().getAdHocOrdering().setValue(adHocOrdering);
        definition.getExecutionSet().getAdHocAutostart().setValue(Boolean.valueOf(adHocAutostart));
        definition.getExecutionSet().getAdHocActivationCondition().setValue(ACTIVATION_CONDITION);
        definition.getExecutionSet().getAdHocCompletionCondition().setValue(COMPLETION_CONDITION);
        definition.getExecutionSet().getOnEntryAction().getValue().addValue(ON_ENTRY_ACTION);
        definition.getExecutionSet().getOnExitAction().getValue().addValue(ON_EXIT_ACTION);
        SubProcessConverterTest.setBaseSubprocessExecutionSetValues((BaseSubprocessTaskExecutionSet)definition.getExecutionSet());
        double nodeX1 = 10.0;
        double nodeY1 = 20.0;
        double nodeX2 = 40.0;
        double nodeY2 = 60.0;
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create((double)nodeX1, (double)nodeY1, (double)nodeX2, (double)nodeY2));
        NodeImpl node = new NodeImpl(ELEMENT_ID);
        node.setContent((Object)view);
        double parentX1 = 30.0;
        double parentY1 = 40.0;
        double parentX2 = 60.0;
        double parentY2 = 100.0;
        NodeImpl parent = new NodeImpl("parentId");
        ViewImpl parentView = new ViewImpl(null, Bounds.create((double)parentX1, (double)parentY1, (double)parentX2, (double)parentY2));
        parent.setContent((Object)parentView);
        EdgeImpl edge = new EdgeImpl("edgeId");
        edge.setContent(Mockito.mock(Child.class));
        node.getInEdges().add(edge);
        edge.setSourceNode((Node)parent);
        edge.setTargetNode((Node)node);
        Result result = this.tested.convertSubProcess((Node)node);
        Assert.assertTrue((boolean)result.isSuccess());
        AdHocSubProcess adHocSubProcess = (AdHocSubProcess)((SubProcessPropertyWriter)result.value()).getElement();
        Assert.assertEquals((Object)ELEMENT_ID, (Object)adHocSubProcess.getId());
        Assert.assertEquals((Object)NAME, (Object)adHocSubProcess.getName());
        Assert.assertEquals((Object)Scripts.asCData((String)NAME), (Object)CustomElement.name.of((BaseElement)adHocSubProcess).get());
        Assert.assertEquals((Object)Scripts.asCData((String)DOCUMENTATION), (Object)DocumentationTextHandler.of((Documentation)((Documentation)adHocSubProcess.getDocumentation().get(0))).getText());
        Assert.assertEquals((Object)adHocOrdering, (Object)adHocSubProcess.getOrdering().getName());
        Assert.assertEquals((Object)adHocAutostart, (Object)CustomElement.autoStart.of((BaseElement)adHocSubProcess).get());
        Assert.assertEquals((Object)Scripts.LANGUAGE.valueOf((String)COMPLETION_CONDITION.getLanguage().toUpperCase()).format(), (Object)((FormalExpression)adHocSubProcess.getCompletionCondition()).getLanguage());
        Assert.assertEquals((Object)Scripts.asCData((String)COMPLETION_CONDITION.getScript()), (Object)FormalExpressionBodyHandler.of((FormalExpression)((FormalExpression)adHocSubProcess.getCompletionCondition())).getBody());
        Assert.assertEquals((Object)ON_ENTRY_ACTION.getLanguage(), (Object)((ScriptTypeValue)Scripts.onEntry((List)adHocSubProcess.getExtensionValues()).getValues().get(0)).getLanguage());
        Assert.assertEquals((Object)Scripts.asCData((String)ON_ENTRY_ACTION.getScript()), (Object)((ScriptTypeValue)Scripts.onEntry((List)adHocSubProcess.getExtensionValues()).getValues().get(0)).getScript());
        Assert.assertEquals((Object)ON_EXIT_ACTION.getLanguage(), (Object)((ScriptTypeValue)Scripts.onExit((List)adHocSubProcess.getExtensionValues()).getValues().get(0)).getLanguage());
        Assert.assertEquals((Object)Scripts.asCData((String)ON_EXIT_ACTION.getScript()), (Object)((ScriptTypeValue)Scripts.onExit((List)adHocSubProcess.getExtensionValues()).getValues().get(0)).getScript());
        SubProcessConverterTest.assertVariables(Arrays.asList(new Pair((Object)"processVar1", (Object)"Object"), new Pair((Object)"processVar2", (Object)"Integer")), (List<Property>)adHocSubProcess.getProperties());
        BPMNShape shape = ((SubProcessPropertyWriter)result.value()).getShape();
        Assert.assertEquals((double)(parentX1 + nodeX1), (double)shape.getBounds().getX(), (double)0.0);
        Assert.assertEquals((double)(parentY1 + nodeY1), (double)shape.getBounds().getY(), (double)0.0);
        Assert.assertEquals((double)(nodeX2 - nodeX1), (double)shape.getBounds().getWidth(), (double)0.0);
        Assert.assertEquals((double)(nodeY2 - nodeY1), (double)shape.getBounds().getHeight(), (double)0.0);
        SubProcessConverterTest.assertBaseSubprocessExecutionSet((SubProcessPropertyWriter)result.value());
    }

    @Test
    public void testConvertMultipleIntanceSubprocess() {
        MultipleInstanceSubprocess definition = new MultipleInstanceSubprocess();
        SubProcessConverterTest.setBaseSubprocessExecutionSetValues((BaseSubprocessTaskExecutionSet)definition.getExecutionSet());
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(UUID.randomUUID().toString());
        node.setContent((Object)view);
        SubProcessPropertyWriter writer = this.tested.convertMultipleInstanceSubprocessNode((Node)node);
        SubProcessConverterTest.assertBaseSubprocessExecutionSet(writer);
    }

    private static void assertVariables(List<Pair<String, String>> expectedVariables, List<Property> properties) {
        Assert.assertEquals((long)expectedVariables.size(), (long)properties.size());
        for (int i = 0; i < expectedVariables.size(); ++i) {
            Pair<String, String> expectedVariable = expectedVariables.get(i);
            Property property = properties.get(i);
            Assert.assertEquals((Object)expectedVariable.getK1(), (Object)property.getId());
            Assert.assertEquals((Object)expectedVariable.getK1(), (Object)property.getName());
            Assert.assertEquals((Object)String.format("_%sItem", expectedVariable.getK1()), (Object)property.getItemSubjectRef().getId());
            Assert.assertEquals((Object)expectedVariable.getK2(), (Object)property.getItemSubjectRef().getStructureRef());
        }
    }

    @Test
    public void testConvertEmbeddedSubprocess() {
        EmbeddedSubprocess definition = new EmbeddedSubprocess();
        SubProcessConverterTest.setBaseSubprocessExecutionSetValues((BaseSubprocessTaskExecutionSet)definition.getExecutionSet());
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(UUID.randomUUID().toString());
        node.setContent((Object)view);
        SubProcessPropertyWriter writer = this.tested.convertEmbeddedSubprocessNode((Node)node);
        SubProcessConverterTest.assertBaseSubprocessExecutionSet(writer);
    }

    @Test
    public void testConvertEventSubprocess() {
        EventSubprocess definition = new EventSubprocess();
        SubProcessConverterTest.setBaseSubprocessExecutionSetValues((BaseSubprocessTaskExecutionSet)definition.getExecutionSet());
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(UUID.randomUUID().toString());
        node.setContent((Object)view);
        SubProcessPropertyWriter writer = this.tested.convertEventSubprocessNode((Node)node);
        SubProcessConverterTest.assertBaseSubprocessExecutionSet(writer);
    }
}

