/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.common.util.ECollections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.DocumentationTextHandler;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractBasePropertyWriterTest<W extends BasePropertyWriter, E extends BaseElement> {
    protected static final String ID = "PARENT_ID";
    protected static final Double X1 = 1.0;
    protected static final Double Y1 = 2.0;
    protected static final Double X2 = 10.0;
    protected static final Double Y2 = 20.0;
    protected static final Double PARENT_ABSOLUTE_X1 = 100.0;
    protected static final Double PARENT_ABSOLUTE_Y1 = 200.0;
    protected static final Double PARENT_ABSOLUTE_X2 = 150.0;
    protected static final Double PARENT_ABSOLUTE_Y2 = 260.0;
    protected E element;
    @Mock
    protected VariableScope variableScope;
    protected W propertyWriter;

    @Before
    public void setUp() {
        this.element = this.mockElement();
        Mockito.when((Object)this.element.getId()).thenReturn((Object)ID);
        ArrayList documentation = new ArrayList();
        Mockito.when((Object)this.element.getDocumentation()).thenReturn((Object)ECollections.newBasicEList());
        this.propertyWriter = this.newPropertyWriter(this.element, this.variableScope);
    }

    protected abstract W newPropertyWriter(E var1, VariableScope var2);

    protected abstract E mockElement();

    @Test
    public void testGetId() {
        Assert.assertEquals((Object)ID, (Object)this.propertyWriter.getId());
    }

    @Test
    public void testSetId() {
        this.propertyWriter.setId(ID);
        ((BaseElement)Mockito.verify(this.element)).setId(ID);
    }

    @Test
    public void testSetBounds() {
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)X1, (double)Y1, (double)X2, (double)Y2);
        this.propertyWriter.setBounds(bounds);
        BPMNShape shape = this.propertyWriter.getShape();
        Assert.assertNotNull((Object)shape);
        Assert.assertEquals((Object)"shape_PARENT_ID", (Object)shape.getId());
        Assert.assertEquals(this.element, (Object)shape.getBpmnElement());
        Bounds shapeBounds = shape.getBounds();
        Assert.assertEquals((float)X1.floatValue(), (float)shapeBounds.getX(), (float)0.0f);
        Assert.assertEquals((float)Y1.floatValue(), (float)shapeBounds.getY(), (float)0.0f);
        Assert.assertEquals((float)(X2.floatValue() - X1.floatValue()), (float)shapeBounds.getWidth(), (float)0.0f);
        Assert.assertEquals((float)(Y2.floatValue() - Y1.floatValue()), (float)shapeBounds.getHeight(), (float)0.0f);
    }

    @Test
    public void testSetAbsoluteBounds() {
        this.testSetAbsoluteBounds(this.createNode());
        Assert.assertFalse((boolean)this.propertyWriter.getShape().isIsExpanded());
    }

    public Node<View, ?> createNode() {
        return this.createNode(new Object());
    }

    public Node<View, ?> createNode(Object definition) {
        Node<View, ?> parentNode = AbstractBasePropertyWriterTest.mockNode(new Object(), org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)PARENT_ABSOLUTE_X1, (double)PARENT_ABSOLUTE_Y1, (double)PARENT_ABSOLUTE_X2, (double)PARENT_ABSOLUTE_Y2));
        return AbstractBasePropertyWriterTest.mockNode(definition, org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)X1, (double)Y1, (double)X2, (double)Y2), parentNode);
    }

    protected void testSetAbsoluteBounds(Node<View, ?> node) {
        org.kie.workbench.common.stunner.core.graph.content.Bounds relativeBounds = ((View)node.getContent()).getBounds();
        double absoluteX = PARENT_ABSOLUTE_X1 + relativeBounds.getUpperLeft().getX();
        double absoluteY = PARENT_ABSOLUTE_Y1 + relativeBounds.getUpperLeft().getY();
        this.propertyWriter.setAbsoluteBounds(node);
        Bounds shapeBounds = this.propertyWriter.getShape().getBounds();
        Assert.assertEquals((double)absoluteX, (double)shapeBounds.getX(), (double)0.0);
        Assert.assertEquals((double)absoluteY, (double)shapeBounds.getY(), (double)0.0);
        Assert.assertEquals((double)relativeBounds.getWidth(), (double)shapeBounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)relativeBounds.getHeight(), (double)shapeBounds.getHeight(), (double)0.0);
    }

    @Test
    public void testGetElement() {
        Assert.assertEquals(this.element, (Object)this.propertyWriter.getElement());
    }

    @Test
    public void testSetNullDocumentation() {
        this.propertyWriter.setDocumentation(null);
        Assert.assertTrue((boolean)this.element.getDocumentation().isEmpty());
    }

    @Test
    public void testSetEmptyDocumentation() {
        this.propertyWriter.setDocumentation("");
        Assert.assertTrue((boolean)this.element.getDocumentation().isEmpty());
    }

    @Test
    public void testSetNonEmptyDocumentation() {
        String value = "some non empty value";
        this.propertyWriter.setDocumentation(value);
        Assert.assertEquals((long)1L, (long)this.element.getDocumentation().size());
        Assert.assertEquals((Object)("<![CDATA[" + value + "]]>"), (Object)DocumentationTextHandler.of((Documentation)((Documentation)this.element.getDocumentation().get(0))).getText());
    }

    @Test
    public void testAddItemDefinition() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        this.propertyWriter.addItemDefinition(itemDefinition);
        Assert.assertTrue((boolean)this.propertyWriter.getItemDefinitions().contains(itemDefinition));
    }

    @Test
    public void testAddRootElement() {
        RootElement rootElement = (RootElement)Mockito.mock(RootElement.class);
        this.propertyWriter.addRootElement(rootElement);
        Assert.assertTrue((boolean)this.propertyWriter.getRootElements().contains(rootElement));
    }

    @Test
    public void testAbsoluteBounds() {
        double parentAbsoluteX = 100.0;
        double parentAbsoluteY = 300.0;
        Node<View, ?> parentNode = AbstractBasePropertyWriterTest.mockNode(new Object(), org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)parentAbsoluteX, (double)parentAbsoluteY, (double)100.0, (double)100.0));
        double childRelativeX = 10.0;
        double childRelativeY = 20.0;
        org.kie.workbench.common.stunner.core.graph.content.Bounds childRelativeBounds = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)childRelativeX, (double)childRelativeY, (double)46.0, (double)56.0);
        Node<View, ?> node = AbstractBasePropertyWriterTest.mockNode(new Object(), childRelativeBounds, parentNode);
        org.kie.workbench.common.stunner.core.graph.content.Bounds expectedResult = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)(parentAbsoluteX + childRelativeX), (double)(parentAbsoluteY + childRelativeY), (double)(parentAbsoluteX + childRelativeX + childRelativeBounds.getWidth()), (double)(parentAbsoluteY + childRelativeY + childRelativeBounds.getHeight()));
        Assert.assertEquals((Object)expectedResult, (Object)BasePropertyWriter.absoluteBounds(node));
    }

    protected static Node<View, ?> mockNode(Object definition, org.kie.workbench.common.stunner.core.graph.content.Bounds bounds) {
        Node node = (Node)Mockito.mock(Node.class);
        View view = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)view.getDefinition()).thenReturn(definition);
        ArrayList inEdges = new ArrayList();
        Mockito.when((Object)node.getInEdges()).thenReturn(inEdges);
        Mockito.when((Object)node.asNode()).thenReturn((Object)node);
        return node;
    }

    protected static Node<View, ?> mockNode(Object definition, org.kie.workbench.common.stunner.core.graph.content.Bounds bounds, Node<View, ?> parent) {
        Node<View, ?> node = AbstractBasePropertyWriterTest.mockNode(definition, bounds);
        Child child = (Child)Mockito.mock(Child.class);
        Edge edge = (Edge)Mockito.mock(Edge.class);
        Mockito.when((Object)edge.getContent()).thenReturn((Object)child);
        Mockito.when((Object)edge.getSourceNode()).thenReturn(parent);
        node.getInEdges().add(edge);
        return node;
    }
}

