/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import junit.framework.TestCase;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Task;
import org.eclipse.emf.common.util.EList;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.ActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;

public class ActivityPropertyWriterTest {
    @Test
    public void testEmptyInputOutputSet() {
        Task task = Factories.bpmn2.createTask();
        ActivityPropertyWriter activityPropertyWriter = new ActivityPropertyWriter((Activity)task, (VariableScope)new FlatVariableScope());
        activityPropertyWriter.setAssignmentsInfo(new AssignmentsInfo("||||"));
        Assert.assertNull((Object)task.getIoSpecification());
    }

    @Test
    public void testNotEmptyInputSet() {
        Task task = Factories.bpmn2.createTask();
        ActivityPropertyWriter activityPropertyWriter = new ActivityPropertyWriter((Activity)task, (VariableScope)new FlatVariableScope());
        activityPropertyWriter.setAssignmentsInfo(new AssignmentsInfo("|A:String|||"));
        Assert.assertNotNull((Object)task.getIoSpecification());
        TestCase.assertTrue((boolean)task.getIoSpecification().getOutputSets().isEmpty());
        Assert.assertEquals((long)1L, (long)task.getIoSpecification().getInputSets().size());
    }

    @Test
    public void testNotEmptyOutputSet() {
        Task task = Factories.bpmn2.createTask();
        ActivityPropertyWriter activityPropertyWriter = new ActivityPropertyWriter((Activity)task, (VariableScope)new FlatVariableScope());
        activityPropertyWriter.setAssignmentsInfo(new AssignmentsInfo("||A:String||"));
        Assert.assertNotNull((Object)task.getIoSpecification());
        TestCase.assertTrue((boolean)task.getIoSpecification().getInputSets().isEmpty());
        Assert.assertEquals((long)1L, (long)task.getIoSpecification().getOutputSets().size());
    }

    @Test
    public void testItShouldCreateOneInputSet() {
        Task task = Factories.bpmn2.createTask();
        ActivityPropertyWriter activityPropertyWriter = new ActivityPropertyWriter((Activity)task, (VariableScope)new FlatVariableScope());
        activityPropertyWriter.setAssignmentsInfo(new AssignmentsInfo("|A:String|||"));
        EList inputSets = task.getIoSpecification().getInputSets();
        Assert.assertEquals((long)1L, (long)inputSets.size());
    }
}

