/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import java.util.List;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.jgroups.util.Util;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.EventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EventPropertyWriterTest {
    private MessageRef messageRef = new MessageRef("someVar", "");
    private static final String sampleStructureRef = "my.var.ref";
    @Mock
    private ItemDefinition itemDefinition;

    @Test
    public void testMessageStructureRef() {
        String elementId = "MY_ID";
        StartEvent startEvent = Factories.bpmn2.createStartEvent();
        startEvent.setId(elementId);
        Mockito.when((Object)this.itemDefinition.getStructureRef()).thenReturn((Object)sampleStructureRef);
        EventPropertyWriter writer = new EventPropertyWriter((Event)startEvent, (VariableScope)new FlatVariableScope()){

            public void setAssignmentsInfo(AssignmentsInfo assignmentsInfo) {
            }

            protected void addEventDefinition(EventDefinition eventDefinition) {
            }

            public List<ItemDefinition> getItemDefinitions() {
                this.itemDefinitions.clear();
                this.itemDefinitions.add(EventPropertyWriterTest.this.itemDefinition);
                return this.itemDefinitions;
            }
        };
        writer.addMessage(this.messageRef);
        Util.assertEquals((Object)this.messageRef.getStructure(), (Object)sampleStructureRef);
        Mockito.when((Object)this.itemDefinition.getStructureRef()).thenReturn((Object)sampleStructureRef);
        this.messageRef.setStructure("nonEmpty");
        writer.addMessage(this.messageRef);
        Util.assertEquals((Object)this.messageRef.getStructure(), (Object)"nonEmpty");
        writer = new EventPropertyWriter((Event)startEvent, (VariableScope)new FlatVariableScope()){

            public void setAssignmentsInfo(AssignmentsInfo assignmentsInfo) {
            }

            protected void addEventDefinition(EventDefinition eventDefinition) {
            }

            public List<ItemDefinition> getItemDefinitions() {
                this.itemDefinitions.clear();
                return this.itemDefinitions;
            }
        };
        this.messageRef.setStructure("");
        writer.addMessage(this.messageRef);
        Util.assertEquals((Object)this.messageRef.getStructure(), (Object)"");
        this.messageRef.setStructure("nonEmpty");
        writer.addMessage(this.messageRef);
        Util.assertEquals((Object)this.messageRef.getStructure(), (Object)"nonEmpty");
    }
}

