/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Task;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.GenericServiceTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskValue;

public class GenericServiceTaskPropertyWriterTest {
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final String SLA_DUE_DATE_CDATA = "<![CDATA[12/25/1983]]>";
    private GenericServiceTaskPropertyWriter w;
    private ServiceTask serviceTask = Factories.bpmn2.createServiceTask();
    private GenericServiceTaskValue value;

    @Before
    public void setUp() {
        PropertyWriterFactory writerFactory = new PropertyWriterFactory();
        this.w = writerFactory.of(this.serviceTask);
        this.value = new GenericServiceTaskValue("Java", "serviceInterface", "serviceOperation", "inMessageStructure", "outMessagetructure");
    }

    @Test
    public void setAndTestJava() {
        this.w.setValue(this.value);
        this.w.setSLADueDate(SLA_DUE_DATE);
        this.w.setAsync(false);
        this.w.setAdHocAutostart(false);
        this.w.setAssignmentsInfo(new AssignmentsInfo());
        this.assertServiceTaskProperties("Java");
        Assert.assertEquals((Object)SLA_DUE_DATE_CDATA, (Object)CustomElement.slaDueDate.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.async.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.autoStart.of((BaseElement)this.serviceTask).get());
        Assert.assertNotNull((Object)Scripts.onEntry((Task)this.serviceTask));
    }

    private void assertServiceTaskProperties(String serviceImplementation) {
        Assert.assertEquals((Object)serviceImplementation, (Object)CustomAttribute.serviceImplementation.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)"serviceOperation", (Object)CustomAttribute.serviceOperation.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)"serviceInterface", (Object)CustomAttribute.serviceInterface.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)"serviceOperation", (Object)this.serviceTask.getOperationRef().getName());
    }

    @Test
    public void setAndTestWebService() {
        this.value.setServiceImplementation("WebServicee");
        this.w.setValue(this.value);
        this.w.setSLADueDate(SLA_DUE_DATE);
        this.w.setAsync(false);
        this.w.setAdHocAutostart(false);
        this.assertServiceTaskProperties("WebServicee");
        Assert.assertEquals((Object)SLA_DUE_DATE_CDATA, (Object)CustomElement.slaDueDate.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.async.of((BaseElement)this.serviceTask).get());
        Assert.assertEquals((Object)false, (Object)CustomElement.autoStart.of((BaseElement)this.serviceTask).get());
    }
}

