/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import bpsim.ElementParameters;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.impl.ArtifactImpl;
import org.eclipse.bpmn2.impl.FlowElementImpl;
import org.eclipse.emf.common.util.EList;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BoundaryEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.Processes;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessesTest {
    private static final String ELEMENT_ID = "ELEMENT_ID";
    @Mock
    private PropertyWriter propertyWriter;
    @Mock
    private BoundaryEventPropertyWriter boundaryEventPropertyWriter;
    @Mock
    private List<RootElement> propertyWriterRootElements;
    @Mock
    private List<ItemDefinition> propertyWriterItemDefinitions;
    @Mock
    private ElementParameters propertyWriterElementParameters;
    @Mock
    private FlowElement flowElement;
    @Mock
    private Artifact artifact;
    @Mock
    private Process process;
    @Mock
    private SubProcess subProcess;
    @Mock
    private EList<FlowElement> flowElements;
    @Mock
    private EList<Artifact> artifacts;
    @Mock
    private Map<String, BasePropertyWriter> childElements;
    @Mock
    private List<RootElement> rootElements;
    @Mock
    private List<ElementParameters> simulationParameters;
    @Mock
    private List<ItemDefinition> itemDefinitions;

    @Before
    public void setUp() {
        Mockito.when((Object)this.propertyWriter.getRootElements()).thenReturn(this.propertyWriterRootElements);
        Mockito.when((Object)this.propertyWriter.getSimulationParameters()).thenReturn((Object)this.propertyWriterElementParameters);
        Mockito.when((Object)this.propertyWriter.getItemDefinitions()).thenReturn(this.propertyWriterItemDefinitions);
        Mockito.when((Object)this.boundaryEventPropertyWriter.getRootElements()).thenReturn(this.propertyWriterRootElements);
        Mockito.when((Object)this.boundaryEventPropertyWriter.getSimulationParameters()).thenReturn((Object)this.propertyWriterElementParameters);
        Mockito.when((Object)this.boundaryEventPropertyWriter.getItemDefinitions()).thenReturn(this.propertyWriterItemDefinitions);
        this.flowElement = new FlowElementImpl(){};
        this.flowElement.setId(ELEMENT_ID);
        this.artifact = new ArtifactImpl(){};
        this.artifact.setId(ELEMENT_ID);
        Mockito.when((Object)this.process.getFlowElements()).thenReturn(this.flowElements);
        Mockito.when((Object)this.process.getArtifacts()).thenReturn(this.artifacts);
        Mockito.when((Object)this.subProcess.getFlowElements()).thenReturn(this.flowElements);
        Mockito.when((Object)this.subProcess.getArtifacts()).thenReturn(this.artifacts);
    }

    @Test
    public void testAddFlowElementChildOnProcess() {
        this.testAddFlowElementCase((FlowElementsContainer)this.process);
    }

    @Test
    public void testAddFlowElementChildOnSubProcess() {
        this.testAddFlowElementCase((FlowElementsContainer)this.subProcess);
    }

    private void testAddFlowElementCase(FlowElementsContainer container) {
        this.testAddElementChild((BasePropertyWriter)this.propertyWriter, container, (BaseElement)this.flowElement);
        ((EList)Mockito.verify(this.flowElements)).add(0, (Object)this.flowElement);
    }

    @Test
    public void testAddBoundaryEventFlowElementOnProcess() {
        this.testAddBoundaryEventFlowElementCase((FlowElementsContainer)this.process);
    }

    @Test
    public void testAddBoundaryEventFlowElementSubProcess() {
        this.testAddBoundaryEventFlowElementCase((FlowElementsContainer)this.subProcess);
    }

    private void testAddBoundaryEventFlowElementCase(FlowElementsContainer container) {
        this.testAddElementChild((BasePropertyWriter)this.boundaryEventPropertyWriter, container, (BaseElement)this.flowElement);
        ((EList)Mockito.verify(this.flowElements)).add((Object)this.flowElement);
    }

    @Test
    public void testAddArtifactElementOnProcess() {
        this.testAddArtifactCase((FlowElementsContainer)this.process);
    }

    @Test
    public void testAddArtifactElementOnSubProcess() {
        this.testAddArtifactCase((FlowElementsContainer)this.subProcess);
    }

    private void testAddArtifactCase(FlowElementsContainer container) {
        this.testAddElementChild((BasePropertyWriter)this.propertyWriter, container, (BaseElement)this.artifact);
        ((EList)Mockito.verify(this.artifacts)).add((Object)this.artifact);
    }

    private void testAddElementChild(BasePropertyWriter propertyWriter, FlowElementsContainer flowElementsContainer, BaseElement baseElement) {
        Mockito.when((Object)propertyWriter.getElement()).thenReturn((Object)baseElement);
        Processes.addChildElement((BasePropertyWriter)propertyWriter, this.childElements, (FlowElementsContainer)flowElementsContainer, this.simulationParameters, this.itemDefinitions, this.rootElements);
        ((Map)Mockito.verify(this.childElements)).put(ELEMENT_ID, propertyWriter);
        ((List)Mockito.verify(this.simulationParameters)).add(this.propertyWriterElementParameters);
        ((List)Mockito.verify(this.rootElements)).addAll(this.propertyWriterRootElements);
        ((List)Mockito.verify(this.itemDefinitions)).addAll(this.propertyWriterItemDefinitions);
    }
}

