/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.common.util.EList;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.SequenceFlowPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.TestSequenceFlowWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.DocumentationTextHandler;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnectorImpl;

public class SequenceFlowPropertyWriterTest {
    private final String SEQ_ID = "SEQ_ID";
    private final String SOURCE_ID = "SOURCE_ID";
    private final String TARGET_ID = "TARGET_ID";

    @Test
    public void setConnectionMagnetsNullLocation() {
        TestSequenceFlowWriter w = new TestSequenceFlowWriter();
        SequenceFlowPropertyWriter p = w.sequenceFlowOf("SEQ_ID");
        float sx = 10.0f;
        float sy = 10.0f;
        float sWidth = 50.0f;
        float sHeight = 70.0f;
        PropertyWriter source = w.nodeOf("SOURCE_ID", sx, sy, sWidth, sHeight);
        float tx = 100.0f;
        float ty = 100.0f;
        float tWidth = 20.0f;
        float tHeight = 30.0f;
        PropertyWriter target = w.nodeOf("TARGET_ID", tx, ty, tWidth, tHeight);
        p.setSource((BasePropertyWriter)source);
        p.setTarget((BasePropertyWriter)target);
        ViewConnectorImpl<org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow> connector = SequenceFlowPropertyWriterTest.makeConnector();
        connector.setSourceConnection((Connection)new MagnetConnection.Builder().build());
        connector.setTargetConnection((Connection)new MagnetConnection.Builder().build());
        p.setConnection(connector);
        BPMNEdge edge = p.getEdge();
        List<Point> expected = Arrays.asList(SequenceFlowPropertyWriterTest.pointOf(sWidth + sx, sHeight / 2.0f + sy), SequenceFlowPropertyWriterTest.pointOf(tx, tHeight / 2.0f + ty));
        EList waypoints = edge.getWaypoint();
        SequenceFlowPropertyWriterTest.assertPointsEqual(expected, (List<Point>)waypoints, "when magnet location is null: source magnet should be right/middle, target magnet should left/middle");
    }

    @Test
    public void setConnectionMagnets() {
        TestSequenceFlowWriter w = new TestSequenceFlowWriter();
        SequenceFlowPropertyWriter p = w.sequenceFlowOf("SEQ_ID");
        float sx = 10.0f;
        float sy = 10.0f;
        float sWidth = 50.0f;
        float sHeight = 70.0f;
        PropertyWriter source = w.nodeOf("SOURCE_ID", sx, sy, sWidth, sHeight);
        float tx = 100.0f;
        float ty = 100.0f;
        float tWidth = 20.0f;
        float tHeight = 30.0f;
        PropertyWriter target = w.nodeOf("TARGET_ID", tx, ty, tWidth, tHeight);
        p.setSource((BasePropertyWriter)source);
        p.setTarget((BasePropertyWriter)target);
        ViewConnectorImpl<org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow> connector = SequenceFlowPropertyWriterTest.makeConnector();
        connector.setSourceConnection((Connection)MagnetConnection.Builder.at((double)1.0, (double)2.0));
        connector.setTargetConnection((Connection)MagnetConnection.Builder.at((double)2.0, (double)3.0));
        p.setConnection(connector);
        BPMNEdge edge = p.getEdge();
        List<Point> expected = Arrays.asList(SequenceFlowPropertyWriterTest.pointOf(sx + 1.0f, sy + 2.0f), SequenceFlowPropertyWriterTest.pointOf(tx + 2.0f, ty + 3.0f));
        EList waypoints = edge.getWaypoint();
        SequenceFlowPropertyWriterTest.assertPointsEqual(expected, (List<Point>)waypoints, "when magnet location is defined, waypoints should be translated into an absolute position");
    }

    @Test
    public void setControlPoints() {
        TestSequenceFlowWriter w = new TestSequenceFlowWriter();
        SequenceFlowPropertyWriter p = w.sequenceFlowOf("SEQ_ID");
        float sx = 10.0f;
        float sy = 10.0f;
        float sWidth = 50.0f;
        float sHeight = 70.0f;
        PropertyWriter source = w.nodeOf("SOURCE_ID", sx, sy, sWidth, sHeight);
        float tx = 100.0f;
        float ty = 100.0f;
        float tWidth = 20.0f;
        float tHeight = 30.0f;
        PropertyWriter target = w.nodeOf("TARGET_ID", tx, ty, tWidth, tHeight);
        p.setSource((BasePropertyWriter)source);
        p.setTarget((BasePropertyWriter)target);
        ViewConnectorImpl<org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow> connector = SequenceFlowPropertyWriterTest.makeConnector();
        connector.setSourceConnection((Connection)MagnetConnection.Builder.at((double)1.0, (double)2.0));
        connector.setTargetConnection((Connection)MagnetConnection.Builder.at((double)2.0, (double)3.0));
        connector.setControlPoints(new ControlPoint[]{ControlPoint.build((Point2D)Point2D.create((double)(sx + 100.0f), (double)(sy + 100.0f))), ControlPoint.build((Point2D)Point2D.create((double)(sx + 150.0f), (double)(sy + 150.0f)))});
        p.setConnection(connector);
        BPMNEdge edge = p.getEdge();
        List<Point> expected = Arrays.asList(SequenceFlowPropertyWriterTest.pointOf(sx + 1.0f, sy + 2.0f), SequenceFlowPropertyWriterTest.pointOf(sx + 100.0f, sy + 100.0f), SequenceFlowPropertyWriterTest.pointOf(sx + 150.0f, sy + 150.0f), SequenceFlowPropertyWriterTest.pointOf(tx + 2.0f, ty + 3.0f));
        EList waypoints = edge.getWaypoint();
        SequenceFlowPropertyWriterTest.assertPointsEqual(expected, (List<Point>)waypoints, "when magnet location is defined, waypoints should be translated into an absolute position");
    }

    @Test
    public void JBPM_7522_shouldPersistProperties() {
        TestSequenceFlowWriter w = new TestSequenceFlowWriter();
        SequenceFlowPropertyWriter p = w.sequenceFlowOf("SEQ_ID");
        String name = "Name";
        String doc = "Doc";
        String priority = "100";
        ScriptTypeValue scriptTypeValue = new ScriptTypeValue("java", "System.out.println(1);");
        p.setName(name);
        p.setDocumentation(doc);
        p.setPriority(priority);
        p.setConditionExpression(scriptTypeValue);
        SequenceFlow seq = (SequenceFlow)p.getFlowElement();
        Assertions.assertThat((String)seq.getName()).isEqualTo(name);
        Assertions.assertThat((String)DocumentationTextHandler.of((Documentation)((Documentation)seq.getDocumentation().get(0))).getText()).isEqualTo(Scripts.asCData((String)doc));
        Assertions.assertThat((String)((String)CustomAttribute.priority.of((BaseElement)seq).get())).isEqualTo(priority);
        Assertions.assertThat((Object)seq.getConditionExpression()).isNotNull();
    }

    private static ViewConnectorImpl<org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow> makeConnector() {
        return new ViewConnectorImpl((Object)new org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow(), Bounds.create((double)0.0, (double)0.0, (double)1000.0, (double)1000.0));
    }

    private static void assertPointsEqual(List<Point> expected, List<Point> given, String message) {
        TestCase.assertEquals((int)expected.size(), (int)given.size());
        for (int i = 0; i < expected.size(); ++i) {
            Point pe = expected.get(i);
            Point pg = given.get(i);
            if (pe.getX() == pg.getX() && pe.getY() == pg.getY()) continue;
            TestCase.failNotEquals((String)message, expected, given);
        }
    }

    private static Point pointOf(double x, double y) {
        Point point = Factories.dc.createPoint();
        point.setX((float)x);
        point.setY((float)y);
        return point;
    }
}

