/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.ElementParameters;
import bpsim.Scenario;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefinitionResolverTest {
    private static final String ID = "PARENT_ID";
    @Mock
    private Definitions definitions;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private BPMNPlane plane;
    @Mock
    private FeatureMap featureMap;
    @Mock
    private Process process;
    @Mock
    private ExtensionAttributeValue extensionAttributeValue;
    @Mock
    private Relationship relationship;
    private DefinitionResolver definitionResolver;
    private EList<DiagramElement> planeElements;
    private List<BPSimDataType> simData = new ArrayList<BPSimDataType>();
    private EList<ExtensionAttributeValue> extensionAttributeValues = ECollections.newBasicEList();
    private EList<Relationship> relationships = ECollections.newBasicEList();

    @Before
    public void setUp() {
        this.planeElements = ECollections.newBasicEList();
        Mockito.when((Object)this.definitions.getRootElements()).thenReturn((Object)ECollections.singletonEList((Object)this.process));
        Mockito.when((Object)this.definitions.getDiagrams()).thenReturn((Object)ECollections.singletonEList((Object)this.diagram));
        Mockito.when((Object)this.definitions.getRelationships()).thenReturn((Object)ECollections.emptyEList());
        Mockito.when((Object)this.featureMap.get((EStructuralFeature)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, true)).thenReturn(this.simData);
        Mockito.when((Object)this.extensionAttributeValue.getValue()).thenReturn((Object)this.featureMap);
        this.extensionAttributeValues.add((Object)this.extensionAttributeValue);
        Mockito.when((Object)this.relationship.getExtensionValues()).thenReturn(this.extensionAttributeValues);
        this.relationships.add((Object)this.relationship);
        Mockito.when((Object)this.definitions.getRelationships()).thenReturn(this.relationships);
        Mockito.when((Object)this.diagram.getPlane()).thenReturn((Object)this.plane);
        Mockito.when((Object)this.plane.getPlaneElement()).thenReturn(this.planeElements);
        this.definitionResolver = new DefinitionResolver(this.definitions, Collections.emptyList());
    }

    @Test
    public void testCalculateResolutionFactor() {
        BPMNDiagram diagram = (BPMNDiagram)Mockito.mock(BPMNDiagram.class);
        Mockito.when((Object)Float.valueOf(diagram.getResolution())).thenReturn((Object)Float.valueOf(0.0f));
        double factor = DefinitionResolver.calculateResolutionFactor((BPMNDiagram)diagram);
        Assert.assertEquals((double)1.0, (double)factor, (double)0.0);
        Mockito.when((Object)Float.valueOf(diagram.getResolution())).thenReturn((Object)Float.valueOf(250.0f));
        factor = DefinitionResolver.calculateResolutionFactor((BPMNDiagram)diagram);
        Assert.assertEquals((double)0.45, (double)factor, (double)0.0);
    }

    @Test
    public void testGetShape() {
        BPMNShape shape = (BPMNShape)Mockito.mock(BPMNShape.class);
        BaseElement bpmnElement = (BaseElement)Mockito.mock(BaseElement.class);
        Mockito.when((Object)shape.getBpmnElement()).thenReturn((Object)bpmnElement);
        Mockito.when((Object)bpmnElement.getId()).thenReturn((Object)ID);
        this.planeElements.add((Object)shape);
        Assert.assertEquals((Object)shape, (Object)this.definitionResolver.getShape(ID));
    }

    @Test
    public void testGetEdge() {
        BPMNEdge edge = (BPMNEdge)Mockito.mock(BPMNEdge.class);
        BaseElement bpmnElement = (BaseElement)Mockito.mock(BaseElement.class);
        Mockito.when((Object)edge.getBpmnElement()).thenReturn((Object)bpmnElement);
        Mockito.when((Object)bpmnElement.getId()).thenReturn((Object)ID);
        this.planeElements.add((Object)edge);
        Assert.assertEquals((Object)edge, (Object)this.definitionResolver.getEdge(ID));
    }

    @Test
    public void testSimulation() {
        String elementRef = "some_element_ref";
        BasicEList scenarios = ECollections.newBasicEList();
        Scenario scenario = (Scenario)Mockito.mock(Scenario.class);
        scenarios.add((Object)scenario);
        BasicEList parameters = ECollections.newBasicEList();
        ElementParameters parameter = (ElementParameters)Mockito.mock(ElementParameters.class);
        Mockito.when((Object)parameter.getElementRef()).thenReturn((Object)elementRef);
        parameters.add((Object)parameter);
        Mockito.when((Object)scenario.getElementParameters()).thenReturn((Object)parameters);
        BPSimDataType simDataType = (BPSimDataType)Mockito.mock(BPSimDataType.class);
        this.simData.add(simDataType);
        Mockito.when((Object)simDataType.getScenario()).thenReturn((Object)scenarios);
        this.setUp();
        Assert.assertEquals((Object)parameter, this.definitionResolver.resolveSimulationParameters(elementRef).get());
    }
}

