/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner;

import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.EdgeConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.EdgePropertyReader;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EdgeConverterTest {
    private EdgeConverter tested;
    @Mock
    private BpmnNode node1;
    @Mock
    private BpmnNode node2;
    @Mock
    private BpmnNode node3;
    @Mock
    private Edge<? extends View<?>, Node> edge;
    @Mock
    private EdgePropertyReader reader;
    private static final String message = "message";
    private static final String key = "key";

    @Before
    public void setUp() {
        Mockito.when((Object)this.reader.getSourceId()).thenReturn((Object)"1");
        Mockito.when((Object)this.reader.getTargetId()).thenReturn((Object)"2");
        this.tested = new EdgeConverter(){

            public Result<BpmnEdge> convertEdge(BaseElement element, Map nodes) {
                return null;
            }
        };
    }

    @Test
    public void resultWithExistingNodes() {
        Map nodes = new Maps.Builder().put((Object)"1", (Object)this.node1).put((Object)"2", (Object)this.node2).put((Object)"3", (Object)this.node3).build();
        Mockito.when((Object)this.reader.getSourceId()).thenReturn((Object)"1");
        Mockito.when((Object)this.reader.getTargetId()).thenReturn((Object)"2");
        Result result = this.tested.result(nodes, this.edge, this.reader, message, key);
        BpmnEdge value = (BpmnEdge)result.value();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.node1, (Object)value.getSource());
        Assert.assertEquals((Object)this.node2, (Object)value.getTarget());
    }

    @Test
    public void resultWithMissingSourceNode() {
        Map nodes = new Maps.Builder().put((Object)"2", (Object)this.node1).build();
        Result result = this.tested.result(nodes, this.edge, this.reader, message, key);
        BpmnEdge value = (BpmnEdge)result.value();
        Assert.assertTrue((boolean)result.isIgnored());
        Assert.assertNull((Object)value);
    }

    @Test
    public void resultWithMissingTargetNode() {
        Map nodes = new Maps.Builder().put((Object)"1", (Object)this.node1).build();
        Result result = this.tested.result(nodes, this.edge, this.reader, message, key);
        BpmnEdge value = (BpmnEdge)result.value();
        Assert.assertTrue((boolean)result.isIgnored());
        Assert.assertNull((Object)value);
    }

    @Test
    public void valid() {
        Map nodes = new Maps.Builder().put((Object)"1", (Object)this.node1).put((Object)"2", (Object)this.node1).build();
        Assert.assertTrue((boolean)this.tested.valid(nodes, "1", "2"));
        Assert.assertFalse((boolean)this.tested.valid(nodes, "1", "3"));
        Assert.assertFalse((boolean)this.tested.valid(nodes, "0", "2"));
        Assert.assertFalse((boolean)this.tested.valid(nodes, "0", "0"));
    }
}

