/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner;

import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.DataStoreReference;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TextAnnotation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.FlowElementConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.activities.CallActivityConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.events.EndEventConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.events.IntermediateCatchEventConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.events.IntermediateThrowEventConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.events.StartEventConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.gateways.GatewayConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.processes.SubProcessConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.tasks.TaskConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.textannotation.TextAnnotationConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FlowElementConverterTest {
    private FlowElementConverter tested;
    @Mock
    private BaseConverterFactory converterFactory;
    @Mock
    private DefinitionResolver definitionResolver;
    @Mock
    private StartEventConverter startEventConverter;
    @Mock
    private EndEventConverter endEventConverter;
    @Mock
    private IntermediateCatchEventConverter eventConverter;
    @Mock
    private IntermediateThrowEventConverter throwEventConverter;
    @Mock
    private TaskConverter taskConverter;
    @Mock
    private GatewayConverter gatewayConverter;
    @Mock
    private SubProcessConverter subProcessConverter;
    @Mock
    private CallActivityConverter callActivityConverter;
    @Mock
    private TextAnnotationConverter textAnnotationConverter;

    @Before
    public void setUp() {
        Mockito.when((Object)this.converterFactory.startEventConverter()).thenReturn((Object)this.startEventConverter);
        Mockito.when((Object)this.converterFactory.endEventConverter()).thenReturn((Object)this.endEventConverter);
        Mockito.when((Object)this.converterFactory.intermediateCatchEventConverter()).thenReturn((Object)this.eventConverter);
        Mockito.when((Object)this.converterFactory.taskConverter()).thenReturn((Object)this.taskConverter);
        Mockito.when((Object)this.converterFactory.intermediateThrowEventConverter()).thenReturn((Object)this.throwEventConverter);
        Mockito.when((Object)this.converterFactory.gatewayConverter()).thenReturn((Object)this.gatewayConverter);
        Mockito.when((Object)this.converterFactory.subProcessConverter()).thenReturn((Object)this.subProcessConverter);
        Mockito.when((Object)this.converterFactory.callActivityConverter()).thenReturn((Object)this.callActivityConverter);
        Mockito.when((Object)this.converterFactory.getDefinitionResolver()).thenReturn((Object)this.definitionResolver);
        Mockito.when((Object)this.converterFactory.textAnnotationConverter()).thenReturn((Object)this.textAnnotationConverter);
        this.tested = new FlowElementConverter(this.converterFactory);
    }

    @Test
    public void convertSupported() {
        StartEvent startEvent = (StartEvent)Mockito.mock(StartEvent.class);
        this.tested.convertNode((FlowElement)startEvent);
        ((StartEventConverter)Mockito.verify((Object)this.startEventConverter)).convert(startEvent);
        EndEvent endEvent = (EndEvent)Mockito.mock(EndEvent.class);
        this.tested.convertNode((FlowElement)endEvent);
        ((EndEventConverter)Mockito.verify((Object)this.endEventConverter)).convert(endEvent);
        BoundaryEvent boundaryEvent = (BoundaryEvent)Mockito.mock(BoundaryEvent.class);
        this.tested.convertNode((FlowElement)boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.eventConverter)).convertBoundaryEvent(boundaryEvent);
        IntermediateCatchEvent intermediateCatchEvent = (IntermediateCatchEvent)Mockito.mock(IntermediateCatchEvent.class);
        this.tested.convertNode((FlowElement)intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.eventConverter)).convert(intermediateCatchEvent);
        IntermediateThrowEvent intermediateThrowEvent = (IntermediateThrowEvent)Mockito.mock(IntermediateThrowEvent.class);
        this.tested.convertNode((FlowElement)intermediateThrowEvent);
        ((IntermediateThrowEventConverter)Mockito.verify((Object)this.throwEventConverter)).convert(intermediateThrowEvent);
        Task task = (Task)Mockito.mock(Task.class);
        this.tested.convertNode((FlowElement)task);
        ((TaskConverter)Mockito.verify((Object)this.taskConverter)).convert(task);
        Gateway gateway = (Gateway)Mockito.mock(Gateway.class);
        this.tested.convertNode((FlowElement)gateway);
        ((GatewayConverter)Mockito.verify((Object)this.gatewayConverter)).convert(gateway);
        SubProcess subProcess = (SubProcess)Mockito.mock(SubProcess.class);
        this.tested.convertNode((FlowElement)subProcess);
        ((SubProcessConverter)Mockito.verify((Object)this.subProcessConverter)).convertSubProcess(subProcess);
        CallActivity callActivity = (CallActivity)Mockito.mock(CallActivity.class);
        this.tested.convertNode((FlowElement)callActivity);
        ((CallActivityConverter)Mockito.verify((Object)this.callActivityConverter)).convert(callActivity);
        TextAnnotation textAnnotation = (TextAnnotation)Mockito.mock(TextAnnotation.class);
        this.tested.convertNode((FlowElement)textAnnotation);
        ((TextAnnotationConverter)Mockito.verify((Object)this.textAnnotationConverter)).convert(textAnnotation);
    }

    public void convertUnsupported() {
        this.assertUnsupported(DataStoreReference.class);
        this.assertUnsupported(DataObjectReference.class);
        this.assertUnsupported(DataObject.class);
    }

    private <T extends FlowElement> void assertUnsupported(Class<T> type) {
        FlowElement element = (FlowElement)Mockito.mock(type);
        Result result = this.tested.convertNode(element);
        Assert.assertTrue((boolean)result.isIgnored());
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertFalse((boolean)result.isFailure());
    }
}

