/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner;

import java.util.Collections;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.common.util.ECollections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.BPMNTestDefinitionFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.GraphBuilder;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingGraphBackendAPI;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.factory.definition.TypeDefinitionFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GraphBuilderTest {
    private static final String BPMN_ID = BindableAdapterUtils.getDefinitionSetId(BPMNDefinitionSet.class);
    private static final String DIAGRAM_UUID = "DIAGRAM_UUID";
    private static final String SUBPROCESS1_ID = "SUBPROCESS1_ID";
    private static final String SUBPROCESS2_ID = "SUBPROCESS2_ID";
    private static final String SUBPROCESS3_ID = "SUBPROCESS3_ID";
    private DefinitionResolver definitionResolver;
    @Mock
    private Process process;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private BPMNPlane plane;
    @Mock
    private Definitions definitions;
    private Graph<DefinitionSet, Node> graph;
    private GraphBuilder graphBuilder;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.diagram.getPlane()).thenReturn((Object)this.plane);
        Mockito.when((Object)this.definitions.getId()).thenReturn((Object)DIAGRAM_UUID);
        Mockito.when((Object)this.definitions.getRootElements()).thenReturn((Object)ECollections.singletonEList((Object)this.process));
        Mockito.when((Object)this.definitions.getDiagrams()).thenReturn((Object)ECollections.singletonEList((Object)this.diagram));
        Mockito.when((Object)this.definitions.getRelationships()).thenReturn((Object)ECollections.emptyEList());
        this.definitionResolver = new DefinitionResolver(this.definitions, Collections.emptyList());
        StunnerTestingGraphBackendAPI api = StunnerTestingGraphBackendAPI.build(BPMNDefinitionSet.class, (TypeDefinitionFactory)new BPMNTestDefinitionFactory());
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(api.getFactoryManager());
        MetadataImpl metadata = new MetadataImpl.MetadataImplBuilder(BindableAdapterUtils.getDefinitionSetId(BPMNDefinitionSet.class)).build();
        Diagram diagram = api.getFactoryManager().newDiagram(this.definitionResolver.getDefinitions().getId(), BPMN_ID, (Metadata)metadata);
        this.graph = diagram.getGraph();
        this.graphBuilder = new GraphBuilder(this.graph, api.getDefinitionManager(), typedFactoryManager, api.getRuleManager(), api.commandFactory, api.commandManager);
    }

    @Test
    public void testBoundsCalculation() {
        double subprocess1X = 10.0;
        double subprocess1Y = 10.0;
        double subprocess1Width = 100.0;
        double subprocess1Height = 200.0;
        EmbeddedSubprocess subprocess1Definition = (EmbeddedSubprocess)Mockito.mock(EmbeddedSubprocess.class);
        Node<? extends View<? extends BPMNViewDefinition>, ?> subprocess1 = GraphBuilderTest.mockNode((BPMNViewDefinition)subprocess1Definition, subprocess1X, subprocess1Y, subprocess1Width, subprocess1Height);
        Mockito.when((Object)subprocess1.getUUID()).thenReturn((Object)SUBPROCESS1_ID);
        BpmnNode subprocess1Node = GraphBuilderTest.mockBpmnNode(subprocess1);
        double subprocess2X = 20.0;
        double subprocess2Y = 20.0;
        double subprocess2Width = 70.0;
        double subprocess2Height = 170.0;
        EmbeddedSubprocess subprocess2Definition = (EmbeddedSubprocess)Mockito.mock(EmbeddedSubprocess.class);
        Node<? extends View<? extends BPMNViewDefinition>, ?> subprocess2 = GraphBuilderTest.mockNode((BPMNViewDefinition)subprocess2Definition, subprocess1X + subprocess2X, subprocess1Y + subprocess2Y, subprocess2Width, subprocess2Height);
        Mockito.when((Object)subprocess2.getUUID()).thenReturn((Object)SUBPROCESS2_ID);
        BpmnNode subprocess2Node = GraphBuilderTest.mockBpmnNode(subprocess2);
        double subprocess3X = 30.0;
        double subprocess3Y = 30.0;
        double subprocess3Width = 30.0;
        double subprocess3Height = 120.0;
        EmbeddedSubprocess subprocess3Definition = (EmbeddedSubprocess)Mockito.mock(EmbeddedSubprocess.class);
        Node<? extends View<? extends BPMNViewDefinition>, ?> subprocess3 = GraphBuilderTest.mockNode((BPMNViewDefinition)subprocess3Definition, subprocess1X + subprocess2X + subprocess3X, subprocess1Y + subprocess2Y + subprocess3Y, subprocess3Width, subprocess3Height);
        Mockito.when((Object)subprocess3.getUUID()).thenReturn((Object)SUBPROCESS3_ID);
        BpmnNode subprocess3Node = GraphBuilderTest.mockBpmnNode(subprocess3);
        Node<? extends View<? extends BPMNViewDefinition>, ?> rootDiagram = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(BPMNDiagramImpl.class), 0.0, 0.0, 1000.0, 1000.0);
        Mockito.when((Object)rootDiagram.getUUID()).thenReturn((Object)DIAGRAM_UUID);
        BpmnNode rootNode = GraphBuilderTest.mockBpmnNode(rootDiagram);
        subprocess1Node.setParent(rootNode);
        subprocess2Node.setParent(subprocess1Node);
        subprocess3Node.setParent(subprocess2Node);
        this.graphBuilder.buildGraph(rootNode);
        this.assertNodePosition(SUBPROCESS1_ID, subprocess1X, subprocess1Y);
        this.assertNodePosition(SUBPROCESS2_ID, subprocess2X, subprocess2Y);
        this.assertNodePosition(SUBPROCESS3_ID, subprocess3X, subprocess3Y);
    }

    private void assertNodePosition(String uuid, double x, double y) {
        Node node = this.graph.getNode(uuid);
        Assert.assertNotNull((Object)node);
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = ((View)node.getContent()).getBounds();
        Assert.assertEquals((double)x, (double)bounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)y, (double)bounds.getUpperLeft().getY(), (double)0.0);
    }

    public static BpmnNode mockBpmnNode(Node<? extends View<? extends BPMNViewDefinition>, ?> node) {
        org.kie.workbench.common.stunner.core.graph.content.Bounds nodeBounds = ((View)node.getContent()).getBounds();
        BasePropertyReader propertyReader = (BasePropertyReader)Mockito.mock(BasePropertyReader.class);
        BPMNShape shape = (BPMNShape)Mockito.mock(BPMNShape.class);
        Bounds bounds = Factories.dc.createBounds();
        bounds.setX(nodeBounds.getUpperLeft().getX().floatValue());
        bounds.setY(nodeBounds.getUpperLeft().getY().floatValue());
        bounds.setWidth(Double.valueOf(nodeBounds.getWidth()).floatValue());
        bounds.setHeight(Double.valueOf(nodeBounds.getHeight()).floatValue());
        org.kie.workbench.common.stunner.core.graph.content.Bounds readerBounds = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)nodeBounds.getUpperLeft().getX(), (double)nodeBounds.getUpperLeft().getY(), (double)nodeBounds.getLowerRight().getX(), (double)nodeBounds.getLowerRight().getY());
        Mockito.when((Object)propertyReader.getBounds()).thenReturn((Object)readerBounds);
        Mockito.when((Object)shape.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)propertyReader.getShape()).thenReturn((Object)shape);
        return BpmnNode.of(node, (BasePropertyReader)propertyReader);
    }

    public static Node<? extends View<? extends BPMNViewDefinition>, ?> mockNode(BPMNViewDefinition definition, double x, double y, double width, double height) {
        return GraphBuilderTest.mockNode(definition, org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)x, (double)y, (double)(x + width), (double)(y + height)));
    }

    private static Node<? extends View<? extends BPMNViewDefinition>, ?> mockNode(BPMNViewDefinition definition, org.kie.workbench.common.stunner.core.graph.content.Bounds bounds) {
        Node node = (Node)Mockito.mock(Node.class);
        ViewImpl view = new ViewImpl((Object)definition, bounds);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        return node;
    }
}

