/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.activities;

import org.eclipse.bpmn2.CallActivity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.activities.CallActivityConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.CallActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CallActivityConverterTest {
    private static final String UUID = "UUID";
    private static final String NAME = "NAME";
    private static final String DOCUMENTATION = "DOCUMENTATION";
    private static final String CALLED_ELEMENT = "CALLED_ELEMENT";
    private static final Boolean INDEPENDENT = Boolean.TRUE;
    private static final Boolean ABORT_PARENT = Boolean.TRUE;
    private static final Boolean WAIT_FOR_COMPLETION = Boolean.TRUE;
    private static final Boolean IS_ASYNC = Boolean.TRUE;
    private static final Boolean SEQUENTIAL = Boolean.TRUE;
    private static final String COLLECTION_INPUT = "COLLECTION_INPUT";
    private static final String COLLECTION_OUTPUT = "COLLECTION_OUTPUT";
    private static final String DATA_INPUT = "DATA_INPUT";
    private static final String DATA_OUTPUT = "DATA_OUTPUT";
    private static final String COMPLETION_CONDITION = "COMPLETION_CONDITION";
    private static final ScriptTypeListValue ON_ENTRY_ACTION = new ScriptTypeListValue();
    private static final ScriptTypeListValue ON_EXIT_ACTION = new ScriptTypeListValue();
    private static final Bounds BOUNDS = Bounds.create();
    private static final SimulationSet SIMULATION_SET = new SimulationSet();
    private static final RectangleDimensionsSet RECTANGLE_DIMENSIONS_SET = new RectangleDimensionsSet();
    private static final FontSet FONT_SET = new FontSet();
    private static final BackgroundSet BACKGROUND_SET = new BackgroundSet();
    private static final AssignmentsInfo ASSIGNMENTS_INFO = new AssignmentsInfo();
    private static final String SLA_DUE_DATE = "12/25/1983";
    @Mock
    private TypedFactoryManager factoryManager;
    @Mock
    private PropertyReaderFactory propertyReaderFactory;
    @Mock
    private CallActivityPropertyReader propertyReader;
    @Mock
    private CallActivity callActivity;
    private CallActivityConverter converter;

    @Before
    public void setUp() {
        ReusableSubprocess definition = new ReusableSubprocess(new BPMNGeneralSet(), new ReusableSubprocessTaskExecutionSet(), new DataIOSet(), new BackgroundSet(), new FontSet(), new RectangleDimensionsSet(), new SimulationSet());
        ViewImpl view = new ViewImpl((Object)definition, Bounds.create());
        NodeImpl node = new NodeImpl(UUID);
        node.setContent((Object)view);
        Mockito.when((Object)this.callActivity.getId()).thenReturn((Object)UUID);
        Mockito.when((Object)this.callActivity.getCalledElement()).thenReturn((Object)CALLED_ELEMENT);
        Mockito.when((Object)this.factoryManager.newNode((String)Matchers.eq((Object)UUID), (Class)Matchers.eq(ReusableSubprocess.class))).thenReturn((Object)node);
        Mockito.when((Object)this.propertyReaderFactory.of(this.callActivity)).thenReturn((Object)this.propertyReader);
        Mockito.when((Object)this.propertyReader.getName()).thenReturn((Object)NAME);
        Mockito.when((Object)this.propertyReader.getDocumentation()).thenReturn((Object)DOCUMENTATION);
        Mockito.when((Object)this.propertyReader.getAssignmentsInfo()).thenReturn((Object)ASSIGNMENTS_INFO);
        Mockito.when((Object)this.propertyReader.getBounds()).thenReturn((Object)BOUNDS);
        Mockito.when((Object)this.propertyReader.getSimulationSet()).thenReturn((Object)SIMULATION_SET);
        Mockito.when((Object)this.propertyReader.getRectangleDimensionsSet()).thenReturn((Object)RECTANGLE_DIMENSIONS_SET);
        Mockito.when((Object)this.propertyReader.getFontSet()).thenReturn((Object)FONT_SET);
        Mockito.when((Object)this.propertyReader.getBackgroundSet()).thenReturn((Object)BACKGROUND_SET);
        Mockito.when((Object)this.propertyReader.isIndependent()).thenReturn((Object)INDEPENDENT);
        Mockito.when((Object)this.propertyReader.isAbortParent()).thenReturn((Object)ABORT_PARENT);
        Mockito.when((Object)this.propertyReader.isWaitForCompletion()).thenReturn((Object)WAIT_FOR_COMPLETION);
        Mockito.when((Object)this.propertyReader.isAsync()).thenReturn((Object)IS_ASYNC);
        Mockito.when((Object)this.propertyReader.isSequential()).thenReturn((Object)SEQUENTIAL);
        Mockito.when((Object)this.propertyReader.getCollectionOutput()).thenReturn((Object)COLLECTION_OUTPUT);
        Mockito.when((Object)this.propertyReader.getCollectionInput()).thenReturn((Object)COLLECTION_INPUT);
        Mockito.when((Object)this.propertyReader.getDataInput()).thenReturn((Object)DATA_INPUT);
        Mockito.when((Object)this.propertyReader.getDataOutput()).thenReturn((Object)DATA_OUTPUT);
        Mockito.when((Object)this.propertyReader.getCompletionCondition()).thenReturn((Object)COMPLETION_CONDITION);
        Mockito.when((Object)this.propertyReader.getOnEntryAction()).thenReturn((Object)ON_ENTRY_ACTION);
        Mockito.when((Object)this.propertyReader.getOnExitAction()).thenReturn((Object)ON_EXIT_ACTION);
        Mockito.when((Object)this.propertyReader.getSlaDueDate()).thenReturn((Object)SLA_DUE_DATE);
        this.converter = new CallActivityConverter(this.factoryManager, this.propertyReaderFactory);
    }

    @Test
    public void testConvertMI() {
        Mockito.when((Object)this.propertyReader.isMultipleInstance()).thenReturn((Object)true);
        BpmnNode bpmnNode = (BpmnNode)this.converter.convert(this.callActivity).value();
        Node result = bpmnNode.value();
        this.assertCommonValues((Node<View<ReusableSubprocess>, Edge>)result);
        Assert.assertTrue((boolean)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getIsMultipleInstance().getValue());
        Assert.assertEquals((Object)SEQUENTIAL, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceExecutionMode().isSequential());
        Assert.assertEquals((Object)COLLECTION_INPUT, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceCollectionInput().getValue());
        Assert.assertEquals((Object)COLLECTION_OUTPUT, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceCollectionOutput().getValue());
        Assert.assertEquals((Object)DATA_INPUT, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceDataInput().getValue());
        Assert.assertEquals((Object)DATA_OUTPUT, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceDataOutput().getValue());
        Assert.assertEquals((Object)COMPLETION_CONDITION, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceCompletionCondition().getValue());
    }

    @Test
    public void testConvertNonMI() {
        Mockito.when((Object)this.propertyReader.isMultipleInstance()).thenReturn((Object)false);
        Mockito.when((Object)this.propertyReader.isSequential()).thenReturn((Object)false);
        Mockito.when((Object)this.propertyReader.getCollectionOutput()).thenReturn(null);
        Mockito.when((Object)this.propertyReader.getCollectionInput()).thenReturn(null);
        Mockito.when((Object)this.propertyReader.getDataInput()).thenReturn(null);
        Mockito.when((Object)this.propertyReader.getDataOutput()).thenReturn(null);
        Mockito.when((Object)this.propertyReader.getCompletionCondition()).thenReturn(null);
        BpmnNode bpmnNode = (BpmnNode)this.converter.convert(this.callActivity).value();
        Node result = bpmnNode.value();
        this.assertCommonValues((Node<View<ReusableSubprocess>, Edge>)result);
        Assert.assertEquals((Object)false, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getIsMultipleInstance().getValue());
        Assert.assertFalse((boolean)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceExecutionMode().isSequential());
        Assert.assertNull((Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceCollectionInput().getValue());
        Assert.assertNull((Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceCollectionOutput().getValue());
        Assert.assertNull((Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceDataInput().getValue());
        Assert.assertNull((Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceDataOutput().getValue());
        Assert.assertNull((Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getMultipleInstanceCompletionCondition().getValue());
    }

    private void assertCommonValues(Node<View<ReusableSubprocess>, Edge> result) {
        Assert.assertEquals((Object)UUID, (Object)result.getUUID());
        Assert.assertEquals((Object)NAME, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getGeneral().getName().getValue());
        Assert.assertEquals((Object)DOCUMENTATION, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)ASSIGNMENTS_INFO, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getDataIOSet().getAssignmentsinfo());
        Assert.assertEquals((Object)BOUNDS, (Object)((View)result.getContent()).getBounds());
        Assert.assertEquals((Object)SIMULATION_SET, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getSimulationSet());
        Assert.assertEquals((Object)RECTANGLE_DIMENSIONS_SET, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getDimensionsSet());
        Assert.assertEquals((Object)FONT_SET, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getFontSet());
        Assert.assertEquals((Object)BACKGROUND_SET, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getBackgroundSet());
        Assert.assertEquals((Object)CALLED_ELEMENT, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getCalledElement().getValue());
        Assert.assertEquals((Object)INDEPENDENT, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getIndependent().getValue());
        Assert.assertEquals((Object)ABORT_PARENT, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getAbortParent().getValue());
        Assert.assertEquals((Object)WAIT_FOR_COMPLETION, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getWaitForCompletion().getValue());
        Assert.assertEquals((Object)IS_ASYNC, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getIsAsync().getValue());
        Assert.assertEquals((Object)ON_ENTRY_ACTION, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getOnEntryAction().getValue());
        Assert.assertEquals((Object)ON_EXIT_ACTION, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getOnExitAction().getValue());
        Assert.assertEquals((Object)SLA_DUE_DATE, (Object)((ReusableSubprocess)((View)result.getContent()).getDefinition()).getExecutionSet().getSlaDueDate().getValue());
    }
}

