/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.events;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BoundaryEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.events.BoundaryEventConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BoundaryEventConverterTest {
    public static final String PARENT_ID = "1";
    public static final String CHILD_ID = "2";
    private BoundaryEventConverter tested;
    @Mock
    protected BpmnNode node1;
    @Mock
    protected BpmnNode node2;
    @Mock
    private BoundaryEvent event;
    @Mock
    private Activity ref;

    @Before
    public void setUp() throws Exception {
        this.tested = new BoundaryEventConverter();
        Mockito.when((Object)this.event.getAttachedToRef()).thenReturn((Object)this.ref);
        Mockito.when((Object)this.ref.getId()).thenReturn((Object)PARENT_ID);
        Mockito.when((Object)this.event.getId()).thenReturn((Object)CHILD_ID);
    }

    @Test
    public void convertEdge() {
        Map nodes = new Maps.Builder().put((Object)PARENT_ID, (Object)this.node1).put((Object)CHILD_ID, (Object)this.node2).build();
        Result result = this.tested.convertEdge(this.event, nodes);
        BpmnEdge value = (BpmnEdge)result.value();
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((Object)this.node1, (Object)value.getSource());
        Assert.assertEquals((Object)this.node2, (Object)value.getTarget());
        Assert.assertTrue((boolean)value.isDocked());
    }

    @Test
    public void convertMissingNodes() {
        HashMap nodes = new HashMap();
        Result result = this.tested.convertEdge(this.event, nodes);
        BpmnEdge value = (BpmnEdge)result.value();
        Assert.assertTrue((boolean)result.isIgnored());
        Assert.assertNull((Object)value);
    }
}

