/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.gateways;

import org.eclipse.bpmn2.Gateway;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingRequest;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TestUtils;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.gateways.GatewayConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.GatewayPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BaseGateway;
import org.kie.workbench.common.stunner.bpmn.definition.EventGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.InclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ParallelGateway;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GatewayConverterTest {
    private static final String UUID = "UUID";
    private static final String NAME = "NAME";
    private static final String DOCUMENTATION = "DOCUMENTATION";
    private static final String DEFAULT_ROUTE = "DEFAULT_ROUTE";
    @Mock
    private TypedFactoryManager factoryManager;
    @Mock
    private PropertyReaderFactory readerFactory;
    @Mock
    private GatewayPropertyReader propertyReader;
    @Mock
    private CircleDimensionSet circleDimensionSet;
    @Mock
    private FontSet fontSet;
    @Mock
    private BackgroundSet backgroundSet;
    @Mock
    private Bounds bounds;
    private GatewayConverter converter;

    @Before
    public void setUp() {
        Mockito.when((Object)this.propertyReader.getName()).thenReturn((Object)NAME);
        Mockito.when((Object)this.propertyReader.getDocumentation()).thenReturn((Object)DOCUMENTATION);
        Mockito.when((Object)this.propertyReader.getDefaultRoute()).thenReturn((Object)DEFAULT_ROUTE);
        Mockito.when((Object)this.propertyReader.getBounds()).thenReturn((Object)this.bounds);
        Mockito.when((Object)this.propertyReader.getCircleDimensionSet()).thenReturn((Object)this.circleDimensionSet);
        Mockito.when((Object)this.propertyReader.getFontSet()).thenReturn((Object)this.fontSet);
        Mockito.when((Object)this.propertyReader.getBackgroundSet()).thenReturn((Object)this.backgroundSet);
        this.converter = new GatewayConverter(this.factoryManager, this.readerFactory, MarshallingRequest.Mode.AUTO);
    }

    @Test
    public void testConvertInclusiveGateway() {
        InclusiveGateway result = this.testConvertGateway(new InclusiveGateway(), Factories.bpmn2.createInclusiveGateway());
        Assert.assertEquals((Object)DEFAULT_ROUTE, (Object)result.getExecutionSet().getDefaultRoute().getValue());
    }

    @Test
    public void testConvertExclusiveGateway() {
        ExclusiveGateway result = this.testConvertGateway(new ExclusiveGateway(), Factories.bpmn2.createExclusiveGateway());
        Assert.assertEquals((Object)DEFAULT_ROUTE, (Object)result.getExecutionSet().getDefaultRoute().getValue());
    }

    @Test
    public void testConvertParallelGateway() {
        this.testConvertGateway(new ParallelGateway(), Factories.bpmn2.createParallelGateway());
    }

    @Test
    public void testConvertEventGateway() {
        this.testConvertGateway(new EventGateway(), Factories.bpmn2.createEventBasedGateway());
    }

    private <D extends BaseGateway, G extends Gateway> D testConvertGateway(D gatewayDefinition, G eclipseGateway) {
        Mockito.when((Object)this.readerFactory.of((Gateway)Matchers.any(eclipseGateway.getClass()))).thenReturn((Object)this.propertyReader);
        Node<View<D>, ?> node = TestUtils.newNode(UUID, gatewayDefinition);
        Mockito.when((Object)this.factoryManager.newNode(UUID, gatewayDefinition.getClass())).thenReturn(node);
        eclipseGateway.setId(UUID);
        BpmnNode bpmnNode = (BpmnNode)this.converter.convert(eclipseGateway).value();
        Assert.assertEquals((Object)UUID, (Object)bpmnNode.value().getUUID());
        BaseGateway result = (BaseGateway)((View)bpmnNode.value().getContent()).getDefinition();
        this.assertCommonValues(result, node);
        return (D)((BaseGateway)((View)node.getContent()).getDefinition());
    }

    private void assertCommonValues(BaseGateway baseGateway, Node<? extends View, Edge> node) {
        Assert.assertEquals((Object)NAME, (Object)baseGateway.getGeneral().getName().getValue());
        Assert.assertEquals((Object)DOCUMENTATION, (Object)baseGateway.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)this.backgroundSet, (Object)baseGateway.getBackgroundSet());
        Assert.assertEquals((Object)this.fontSet, (Object)baseGateway.getFontSet());
        Assert.assertEquals((Object)this.circleDimensionSet, (Object)baseGateway.getDimensionsSet());
        Assert.assertEquals((Object)this.bounds, (Object)((View)node.getContent()).getBounds());
    }
}

