/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.processes;

import junit.framework.TestCase;
import org.eclipse.bpmn2.AdHocOrdering;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.SubProcess;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.processes.SubProcessConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.AdHocSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

@Ignore
public class SubProcessConverterTest {
    private final String SLA_DUE_DATE = "12/25/1983";
    private DefinitionResolver definitionResolver;
    private SubProcessConverter tested;

    @Test
    public void createNode() {
        TestCase.assertTrue((boolean)AdHocSubprocess.class.isInstance(((View)this.tested.createNode("id").getContent()).getDefinition()));
    }

    @Test
    public void createProcessData() {
        TestCase.assertTrue((boolean)ProcessData.class.isInstance(this.tested.createProcessData("id")));
    }

    @Test
    public void testCreateAdHocSubprocessTaskExecutionSet() {
        AdHocSubProcess adHocSubProcess = (AdHocSubProcess)Mockito.mock(AdHocSubProcess.class);
        PowerMockito.when((Object)adHocSubProcess.getCompletionCondition()).thenReturn(Mockito.mock(FormalExpression.class));
        PowerMockito.when((Object)adHocSubProcess.getOrdering()).thenReturn((Object)AdHocOrdering.SEQUENTIAL);
        TestCase.assertTrue((boolean)AdHocSubprocessTaskExecutionSet.class.isInstance(this.tested.createAdHocSubprocessTaskExecutionSet(new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolver.getDiagram(), this.definitionResolver))));
    }

    @Test
    public void testConvertAdHocSubprocessNode() {
        AdHocSubProcess subProcess = Factories.bpmn2.createAdHocSubProcess();
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess((SubProcess)subProcess);
        BpmnNode node = (BpmnNode)result.value();
        AdHocSubprocess adHocSubprocess = (AdHocSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)adHocSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)adHocSubprocess.getExecutionSet());
    }

    @Test
    public void testConvertMultInstanceSubprocessNode() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        subProcess.setLoopCharacteristics((LoopCharacteristics)Factories.bpmn2.createMultiInstanceLoopCharacteristics());
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        MultipleInstanceSubprocess miSubProcess = (MultipleInstanceSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)miSubProcess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)miSubProcess.getExecutionSet());
    }

    @Test
    public void testConvertEmbeddedSubprocessNode() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        EmbeddedSubprocess embeddedSubprocess = (EmbeddedSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)embeddedSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)embeddedSubprocess.getExecutionSet());
    }

    @Test
    public void testConvertEventSubprocessNode() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        subProcess.setTriggeredByEvent(Boolean.TRUE.booleanValue());
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        EventSubprocess eventSubprocess = (EventSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)eventSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)eventSubprocess.getExecutionSet());
    }

    private void assertBaseSubprocessExecutionSet(BaseSubprocessTaskExecutionSet executionSet) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getIsAsync());
        TestCase.assertTrue((boolean)executionSet.getIsAsync().getValue());
        Assert.assertNotNull((Object)executionSet.getSlaDueDate());
        TestCase.assertTrue((boolean)executionSet.getSlaDueDate().getValue().contains("12/25/1983"));
    }
}

