/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.Collections;
import java.util.UUID;
import org.eclipse.bpmn2.AdHocOrdering;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.AdHocSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AdHocSubProcessPropertyReaderTest {
    private static final String SCRIPT = "SCRIPT";
    @Mock
    private AdHocSubProcess process;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private DefinitionResolver definitionResolver;
    private AdHocSubProcessPropertyReader propertyReader;
    private DefinitionResolver definitionResolverReal;
    private AdHocSubProcessPropertyReader tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add((Object)Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add((Object)bpmnDiagram);
        this.definitionResolverReal = new DefinitionResolver(definitions, Collections.emptyList());
        this.propertyReader = new AdHocSubProcessPropertyReader(this.process, this.diagram, this.definitionResolver);
    }

    public void testGetAdHocCompletionConditionWithFormalExpression() {
        for (Scripts.LANGUAGE language : Scripts.LANGUAGE.values()) {
            this.testGetAdHocCompletionConditionWithFormalExpression(new ScriptTypeValue(language.language(), SCRIPT), language.format(), SCRIPT);
        }
    }

    @Test
    public void testGetAdHocCompletionConditionWithoutFormalExpression() {
        Mockito.when((Object)this.process.getCompletionCondition()).thenReturn(null);
        Assert.assertEquals((Object)new ScriptTypeValue(Scripts.LANGUAGE.MVEL.language(), "autocomplete"), (Object)this.propertyReader.getAdHocCompletionCondition());
    }

    private void testGetAdHocCompletionConditionWithFormalExpression(ScriptTypeValue expectedValue, String currentLanguage, String currentBody) {
        FormalExpression formalExpression = (FormalExpression)Mockito.mock(FormalExpression.class);
        Mockito.when((Object)formalExpression.getLanguage()).thenReturn((Object)currentLanguage);
        Mockito.when((Object)formalExpression.getBody()).thenReturn((Object)currentBody);
        Mockito.when((Object)this.process.getCompletionCondition()).thenReturn((Object)formalExpression);
        Assert.assertEquals((Object)expectedValue, (Object)this.propertyReader.getAdHocCompletionCondition());
    }

    @Test
    public void testGetAdHocOrderingSequential() {
        this.testGetAdHocOrdering("Sequential", AdHocOrdering.SEQUENTIAL);
    }

    @Test
    public void testGetAdHocOrderingParallel() {
        this.testGetAdHocOrdering("Parallel", AdHocOrdering.PARALLEL);
    }

    private void testGetAdHocOrdering(String expectedValue, AdHocOrdering currentOrdering) {
        Mockito.when((Object)this.process.getOrdering()).thenReturn((Object)currentOrdering);
        Assert.assertEquals((Object)expectedValue, (Object)this.propertyReader.getAdHocOrdering());
    }

    @Test
    public void testIsAdHocAutostart_true() {
        String id = UUID.randomUUID().toString();
        AdHocSubProcess adHocSubProcess = Factories.bpmn2.createAdHocSubProcess();
        adHocSubProcess.setId(id);
        CustomElement.autoStart.of((BaseElement)adHocSubProcess).set((Object)Boolean.TRUE);
        this.tested = new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertTrue((boolean)this.tested.isAdHocAutostart());
    }

    @Test
    public void testIsAdHocAutostart_false() {
        String id = UUID.randomUUID().toString();
        AdHocSubProcess adHocSubProcess = Factories.bpmn2.createAdHocSubProcess();
        adHocSubProcess.setId(id);
        CustomElement.autoStart.of((BaseElement)adHocSubProcess).set((Object)Boolean.FALSE);
        this.tested = new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertFalse((boolean)this.tested.isAdHocAutostart());
    }

    @Test
    public void testIsAdHocActivationCondition() {
        AdHocSubProcess adHocSubProcess = Factories.bpmn2.createAdHocSubProcess();
        CustomElement.customActivationCondition.of((BaseElement)adHocSubProcess).set((Object)"some condition");
        this.tested = new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertEquals((Object)Scripts.asCData((String)"some condition"), (Object)this.tested.getAdHocActivationCondition());
    }

    @Test
    public void testIsAsync() {
        AdHocSubProcess adHocSubProcess = Factories.bpmn2.createAdHocSubProcess();
        CustomElement.async.of((BaseElement)adHocSubProcess).set((Object)Boolean.TRUE);
        this.tested = new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertTrue((boolean)this.tested.isAsync());
    }

    @Test
    public void testGetSlaDueDate() {
        String rawSlaDueDate = "12/25/1983";
        AdHocSubProcess adHocSubProcess = Factories.bpmn2.createAdHocSubProcess();
        CustomElement.slaDueDate.of((BaseElement)adHocSubProcess).set((Object)rawSlaDueDate);
        this.tested = new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertTrue((boolean)this.tested.getSlaDueDate().contains(rawSlaDueDate));
    }
}

