/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.Collections;
import java.util.UUID;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.CallActivityPropertyReader;

public class CallActivityPropertyReaderTest {
    private DefinitionResolver definitionResolver;
    private CallActivityPropertyReader tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add((Object)Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add((Object)bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
    }

    @Test
    public void testIsCase_true() {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertTrue((boolean)this.tested.isCase());
    }

    @Test
    public void testIsCase_false() {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.FALSE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertFalse((boolean)this.tested.isCase());
    }

    @Test
    public void testIsAdHocAutostart_true() {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.autoStart.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertTrue((boolean)this.tested.isAdHocAutostart());
    }

    @Test
    public void testIsAdHocAutostart_false() {
        String id = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(id);
        CustomElement.autoStart.of((BaseElement)callActivity).set((Object)Boolean.FALSE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertFalse((boolean)this.tested.isAdHocAutostart());
    }

    @Test
    public void testAbortParentTrue() {
        this.testAbortParent(true);
    }

    @Test
    public void testAbortParentFalse() {
        this.testAbortParent(false);
    }

    private void testAbortParent(boolean value) {
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        CustomElement.abortParent.of((BaseElement)callActivity).set((Object)value);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertEquals((Object)value, (Object)this.tested.isAbortParent());
    }

    @Test
    public void testIsAsync() {
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        CustomElement.async.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertTrue((boolean)this.tested.isAsync());
    }

    @Test
    public void testGetSlaDueDate() {
        String rawSlaDueDate = "12/25/1983";
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        CustomElement.slaDueDate.of((BaseElement)callActivity).set((Object)rawSlaDueDate);
        this.tested = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        Assert.assertTrue((boolean)this.tested.getSlaDueDate().contains(rawSlaDueDate));
    }
}

