/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.CaseFileVariableReader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseFileVariableReaderTest {
    private List<Property> properties;
    @Mock
    protected Property property1;
    @Mock
    protected Property property2;
    @Mock
    protected Property property3;
    @Mock
    protected Property property4;
    @Mock
    protected ItemDefinition definition;

    @Before
    public void setup() {
        this.properties = new ArrayList<Property>();
        this.properties.add(this.property1);
        this.properties.add(this.property2);
        this.properties.add(this.property3);
        this.properties.add(this.property4);
        Mockito.when((Object)this.property1.getName()).thenReturn((Object)"caseFile_CFV1");
        Mockito.when((Object)this.property1.getId()).thenReturn((Object)"caseFile_CFV1");
        Mockito.when((Object)this.property1.getItemSubjectRef()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.property2.getName()).thenReturn(null);
        Mockito.when((Object)this.property2.getId()).thenReturn((Object)"caseFile_CFV2");
        Mockito.when((Object)this.property2.getItemSubjectRef()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getStructureRef()).thenReturn((Object)"Boolean");
        Mockito.when((Object)this.property3.getName()).thenReturn((Object)"PV1");
        Mockito.when((Object)this.property3.getId()).thenReturn((Object)"PV1");
        Mockito.when((Object)this.property4.getName()).thenReturn(null);
        Mockito.when((Object)this.property4.getId()).thenReturn((Object)"PV2");
    }

    @Test
    public void getCaseFileVariables() {
        String caseFileVariables = CaseFileVariableReader.getCaseFileVariables(this.properties);
        Assert.assertEquals((Object)caseFileVariables, (Object)"CFV1:Boolean,CFV2:Boolean");
    }

    @Test
    public void isCaseFileVariable() {
        boolean isCaseFile1 = CaseFileVariableReader.isCaseFileVariable((Property)this.property1);
        Assert.assertTrue((boolean)isCaseFile1);
        boolean isCaseFile2 = CaseFileVariableReader.isCaseFileVariable((Property)this.property2);
        Assert.assertTrue((boolean)isCaseFile2);
        boolean isCaseFile3 = CaseFileVariableReader.isCaseFileVariable((Property)this.property3);
        Assert.assertFalse((boolean)isCaseFile3);
        boolean isCaseFile4 = CaseFileVariableReader.isCaseFileVariable((Property)this.property4);
        Assert.assertFalse((boolean)isCaseFile4);
    }
}

