/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.SubProcessPropertyReader;

public class EmbeddedSubprocessPropertyReaderTest {
    private DefinitionResolver definitionResolverReal;
    private SubProcessPropertyReader tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add((Object)Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add((Object)bpmnDiagram);
        this.definitionResolverReal = new DefinitionResolver(definitions, Collections.emptyList());
    }

    @Test
    public void testIsAsync() {
        SubProcess embeddedSubProcess = Factories.bpmn2.createSubProcess();
        CustomElement.async.of((BaseElement)embeddedSubProcess).set((Object)Boolean.TRUE);
        this.tested = new SubProcessPropertyReader(embeddedSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        TestCase.assertTrue((boolean)this.tested.isAsync());
    }

    @Test
    public void testGetSlaDueDate() {
        String rawSlaDueDate = "12/25/1983";
        SubProcess embeddedSubProcess = Factories.bpmn2.createSubProcess();
        CustomElement.slaDueDate.of((BaseElement)embeddedSubProcess).set((Object)rawSlaDueDate);
        this.tested = new SubProcessPropertyReader(embeddedSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        TestCase.assertTrue((boolean)this.tested.getSlaDueDate().contains(rawSlaDueDate));
    }
}

