/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Optional;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.emf.common.util.ArrayDelegatingEList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.InputAssignmentReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InputAssignmentReaderTest {
    public static final String ID = "PARENT_ID";
    @Mock
    private DataInputAssociation association;
    @Mock
    DataInput element;

    public void urlEncodeConstants() throws UnsupportedEncodingException {
        String decoded = "<<<#!!!#>>>";
        String expected = URLEncoder.encode("<<<#!!!#>>>", "UTF-8");
        Assignment assignment = InputAssignmentReaderTest.createAssignment("<<<#!!!#>>>");
        InputAssignmentReader iar = new InputAssignmentReader(assignment, ID);
        AssociationDeclaration associationDeclaration = iar.getAssociationDeclaration();
        Assert.assertEquals((Object)AssociationDeclaration.Type.FromTo, (Object)associationDeclaration.getType());
        Assert.assertEquals((Object)expected, (Object)associationDeclaration.getSource());
    }

    private static Assignment createAssignment(String decodedBody) {
        Assignment assignment = Factories.bpmn2.createAssignment();
        FormalExpression from = Factories.bpmn2.createFormalExpression();
        FormalExpressionBodyHandler.of((FormalExpression)from).setBody(decodedBody);
        FormalExpression to = Factories.bpmn2.createFormalExpression();
        FormalExpressionBodyHandler.of((FormalExpression)to).setBody(ID);
        assignment.setFrom((Expression)from);
        assignment.setTo((Expression)to);
        return assignment;
    }

    @Test
    public void testNullBody() {
        Assignment assignment = InputAssignmentReaderTest.createAssignment(null);
        InputAssignmentReader iar = new InputAssignmentReader(assignment, ID);
        AssociationDeclaration associationDeclaration = iar.getAssociationDeclaration();
        Assert.assertEquals((Object)AssociationDeclaration.Type.FromTo, (Object)associationDeclaration.getType());
        Assert.assertEquals((Object)"", (Object)associationDeclaration.getSource());
    }

    @Test
    public void testNullAssociations() {
        Mockito.when((Object)this.association.getSourceRef()).thenReturn((Object)new ArrayDelegatingEList<ItemAwareElement>(){

            public Object[] data() {
                return null;
            }
        });
        Mockito.when((Object)this.association.getAssignment()).thenReturn((Object)new ArrayDelegatingEList<Assignment>(){

            public Object[] data() {
                return null;
            }
        });
        Mockito.when((Object)this.association.getTargetRef()).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getName()).thenReturn((Object)"someName");
        Optional reader = InputAssignmentReader.fromAssociation((DataInputAssociation)this.association);
        Assert.assertEquals((Object)false, (Object)reader.isPresent());
    }
}

