/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties;

import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.emf.common.util.EList;
import org.jboss.drools.DroolsPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TestUtils;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.ScriptTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ScriptTaskPropertyReaderTest {
    private static final String METADATA_ELEMENT_NAME = "customAsync";
    private static final String SCRIPT = "SCRIPT";
    @Mock
    private ScriptTask task;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private DefinitionResolver definitionResolver;
    private ScriptTaskPropertyReader propertyReader;

    @Before
    public void setUp() {
        this.propertyReader = new ScriptTaskPropertyReader(this.task, this.diagram, this.definitionResolver);
    }

    @Test
    public void testGetScript() {
        for (Scripts.LANGUAGE language : Scripts.LANGUAGE.values()) {
            this.testGetScript(new ScriptTypeValue(language.language(), SCRIPT), language.format(), SCRIPT);
        }
    }

    @Test
    public void testGetScriptNotConfigured() {
        this.testGetScript(new ScriptTypeValue(Scripts.LANGUAGE.JAVA.language(), null), null, null);
    }

    private void testGetScript(ScriptTypeValue expectedValue, String currentLanguage, String currentScript) {
        Mockito.when((Object)this.task.getScriptFormat()).thenReturn((Object)currentLanguage);
        Mockito.when((Object)this.task.getScript()).thenReturn((Object)currentScript);
        Assert.assertEquals((Object)expectedValue, (Object)this.propertyReader.getScript());
    }

    @Test
    public void testIsAsyncTrue() {
        this.testIsAsync(true, "true");
    }

    @Test
    public void testIsAsyncFalse() {
        this.testIsAsync(false, "false");
        this.testIsAsync(false, null);
    }

    private void testIsAsync(boolean expectedValue, String extensionValue) {
        EList<ExtensionAttributeValue> extensionValues = TestUtils.mockExtensionValues(DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, METADATA_ELEMENT_NAME, extensionValue);
        Mockito.when((Object)this.task.getExtensionValues()).thenReturn(extensionValues);
        Assert.assertEquals((Object)expectedValue, (Object)this.propertyReader.isAsync());
    }
}

