/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.sequenceflows;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.UserTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.SequenceFlowPropertyReader;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.sequenceflows.SequenceFlowConverter;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class SequenceFlowConverterTest {
    public static final String SOURCE_ID = "1";
    public static final String TARGET_ID = "2";
    private SequenceFlowConverter tested;
    @Mock
    private TypedFactoryManager factoryManager;
    @Mock
    private PropertyReaderFactory propertyReaderFactory;
    @Mock
    private Edge<View<org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow>, Node> edge;
    @Mock
    private View<org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow> content;
    @Mock
    private org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow def;
    @Mock
    private SequenceFlowPropertyReader reader;

    @Before
    public void setUp() throws Exception {
        PowerMockito.when((Object)this.factoryManager.newEdge(Matchers.anyString(), (Class)Matchers.eq(org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow.class))).thenReturn(this.edge);
        PowerMockito.when((Object)this.edge.getContent()).thenReturn(this.content);
        PowerMockito.when((Object)this.content.getDefinition()).thenReturn((Object)this.def);
        PowerMockito.when((Object)this.propertyReaderFactory.of((SequenceFlow)Matchers.any(SequenceFlow.class))).thenReturn((Object)this.reader);
        PowerMockito.when((Object)this.reader.getSourceId()).thenReturn((Object)SOURCE_ID);
        PowerMockito.when((Object)this.reader.getTargetId()).thenReturn((Object)TARGET_ID);
        this.tested = new SequenceFlowConverter(this.factoryManager, this.propertyReaderFactory);
    }

    @Test
    public void convertEdge() {
        SequenceFlow sequenceFlow = Bpmn2Factory.eINSTANCE.createSequenceFlow();
        UserTask source = Bpmn2Factory.eINSTANCE.createUserTask();
        sequenceFlow.setSourceRef((FlowNode)source);
        BusinessRuleTask target = Bpmn2Factory.eINSTANCE.createBusinessRuleTask();
        sequenceFlow.setTargetRef((FlowNode)target);
        Result result = this.tested.convertEdge(sequenceFlow, new HashMap());
        Assert.assertTrue((boolean)result.isIgnored());
        Assert.assertNull((Object)result.value());
        Map nodes = new Maps.Builder().put((Object)SOURCE_ID, Mockito.mock(BpmnNode.class)).put((Object)TARGET_ID, Mockito.mock(BpmnNode.class)).build();
        result = this.tested.convertEdge(sequenceFlow, nodes);
        Assert.assertTrue((boolean)result.isSuccess());
        BpmnEdge.Simple value = (BpmnEdge.Simple)result.value();
        Assert.assertEquals(this.edge, (Object)value.getEdge());
    }
}

