/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.marshall.service.BPMNClientDiagramService;
import org.kie.workbench.common.stunner.bpmn.client.marshall.service.BPMNClientMarshalling;
import org.kie.workbench.common.stunner.bpmn.client.workitem.WorkItemDefinitionClientService;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.AdHoc;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Executable;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.GlobalVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Package;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.ProcessInstanceDescription;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.ProcessType;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Version;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.Imports;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.AdvancedData;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNDiagramFactory;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.registry.definition.TypeDefinitionSetRegistry;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

@RunWith(value=MockitoJUnitRunner.class)
public class BPMNClientDiagramServiceTest {
    private static final String DEF_SET_ID = BPMNClientMarshalling.getDefinitionSetId();
    private static final String SHAPE_SET_ID = BPMNClientMarshalling.getDefinitionSetId() + "ShapeSet";
    private static final WorkItemDefinition WID1 = new WorkItemDefinition().setName("wid1");
    private static final WorkItemDefinition WID2 = new WorkItemDefinition().setName("wid2");
    private static final WorkItemDefinition WID3 = new WorkItemDefinition().setName("wid3");
    private static final Collection<WorkItemDefinition> WIDS = Arrays.asList(WID1, WID2, WID3);
    private static final String PATH_DIAGRAM = "org/kie/workbench/common/stunner/bpmn/client/marshall/testFlight.bpmn";
    private static String xml;
    private BPMNClientDiagramService tested;
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private BPMNClientMarshalling marshalling;
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private BPMNDiagramFactory diagramFactory;
    @Mock
    private ShapeManager shapeManager;
    @Mock
    private WorkItemDefinitionClientService widService;
    private Promises promises;
    @Mock
    private TypeDefinitionSetRegistry definitionSetRegistry;
    @Mock
    private Graph<DefinitionSet, Node> graph;
    private Name processName;
    private Documentation processDocumentation;
    private Id processId;
    private Package packageProperty;
    private Version version;
    private AdHoc adHoc;
    private ProcessInstanceDescription processInstanceDescription;
    private Executable executable;
    private ProcessData processData;
    private AdvancedData advancedData;
    @Mock
    private Imports imports;
    private GlobalVariables globalVariables;
    @Mock
    private SLADueDate slaDueDate;
    private DiagramSet diagramSet;
    private ProcessType processType;
    private BPMNDiagramImpl bpmnDiagram;
    private List<Node> nodes;

    @Before
    public void setUp() {
        this.promises = new SyncPromises();
        ShapeSet shapeSet = (ShapeSet)Mockito.mock(ShapeSet.class);
        Mockito.when((Object)shapeSet.getId()).thenReturn((Object)SHAPE_SET_ID);
        Mockito.when((Object)this.shapeManager.getDefaultShapeSet((String)Matchers.eq((Object)DEF_SET_ID))).thenReturn((Object)shapeSet);
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn(Mockito.mock(TypeDefinitionSetRegistry.class));
        Mockito.when((Object)this.widService.call(Matchers.any())).thenReturn((Object)this.promises.create((resolve, reject) -> resolve.onInvoke(WIDS)));
        this.processName = new Name("");
        this.processId = new Id("");
        this.processDocumentation = new Documentation("someDocumentation");
        this.packageProperty = new Package("some.package");
        this.version = new Version("1.0");
        this.adHoc = new AdHoc(Boolean.valueOf(false));
        this.processInstanceDescription = new ProcessInstanceDescription("description");
        this.executable = new Executable(Boolean.valueOf(false));
        this.globalVariables = new GlobalVariables("GL1:java.lang.String:[],GL2:java.lang.Boolean:[]");
        this.slaDueDate = new SLADueDate("");
        this.processType = new ProcessType();
        this.diagramSet = new DiagramSet(this.processName, this.processDocumentation, this.processId, this.packageProperty, this.processType, this.version, this.adHoc, this.processInstanceDescription, this.imports, this.executable, this.slaDueDate);
        this.bpmnDiagram = new BPMNDiagramImpl(this.diagramSet, this.processData, new CaseManagementSet(), new BackgroundSet(), new FontSet(), new RectangleDimensionsSet(), this.advancedData);
        this.nodes = Arrays.asList(this.createNode(this.bpmnDiagram));
        this.tested = new BPMNClientDiagramService(this.definitionManager, this.marshalling, this.factoryManager, this.diagramFactory, this.shapeManager, this.promises, this.widService);
    }

    public static String loadStreamAsString(String path) throws IOException {
        String str;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        InputStreamReader isReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    private Node createNode(Object content) {
        NodeImpl node = new NodeImpl(UUID.uuid());
        node.setContent((Object)new ViewImpl(content, new Bounds(new Bound(Double.valueOf(0.0), Double.valueOf(0.0)), new Bound(Double.valueOf(1.0), Double.valueOf(1.0)))));
        return node;
    }

    @Test
    public void testNameAndIdAsFileName() throws IOException {
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn((Object)this.definitionSetRegistry);
        Mockito.when((Object)this.marshalling.unmarshall((Metadata)Matchers.any(), (String)Matchers.any())).thenReturn(this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(this.nodes);
        this.tested.transform("someFile", xml, (ServiceCallback)new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram item) {
            }

            public void onError(ClientRuntimeError error) {
            }
        });
        Assert.assertEquals((Object)"someFile", (Object)this.diagramSet.getName().getValue());
        Assert.assertEquals((Object)"someFile", (Object)this.diagramSet.getId().getValue());
    }

    @Test
    public void testNameAndIdAsDefaultIfEmpty() {
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn((Object)this.definitionSetRegistry);
        Mockito.when((Object)this.marshalling.unmarshall((Metadata)Matchers.any(), (String)Matchers.any())).thenReturn(this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(this.nodes);
        this.tested.transform("default", xml, (ServiceCallback)new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram item) {
            }

            public void onError(ClientRuntimeError error) {
            }
        });
        Assert.assertEquals((Object)"default", (Object)this.diagramSet.getName().getValue());
        Assert.assertEquals((Object)"default", (Object)this.diagramSet.getId().getValue());
    }

    @Test
    public void testNameAndIdAsDefaultIfNotEmpty() {
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn((Object)this.definitionSetRegistry);
        Mockito.when((Object)this.marshalling.unmarshall((Metadata)Matchers.any(), (String)Matchers.any())).thenReturn(this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(this.nodes);
        this.diagramSet.getName().setValue("somePreviousName");
        this.diagramSet.getId().setValue("somePreviousId");
        this.tested.transform("default", xml, (ServiceCallback)new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram item) {
            }

            public void onError(ClientRuntimeError error) {
            }
        });
        Assert.assertEquals((Object)"somePreviousName", (Object)this.diagramSet.getName().getValue());
        Assert.assertEquals((Object)"somePreviousId", (Object)this.diagramSet.getId().getValue());
    }

    @Test
    public void testNameAndIdDefaultOnNewDiagram() {
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn((Object)this.definitionSetRegistry);
        Mockito.when((Object)this.marshalling.unmarshall((Metadata)Matchers.any(), (String)Matchers.any())).thenReturn(this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(this.nodes);
        this.tested.transform("default", xml, (ServiceCallback)new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram item) {
            }

            public void onError(ClientRuntimeError error) {
            }
        });
        Assert.assertEquals((Object)"default", (Object)this.diagramSet.getName().getValue());
        Assert.assertEquals((Object)"default", (Object)this.diagramSet.getId().getValue());
    }

    @Test
    public void testTransformNewDiagram() {
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        String xml = "";
        MetadataImpl metadata = new MetadataImpl();
        metadata.setDefinitionSetId(DEF_SET_ID);
        DiagramImpl result = new DiagramImpl("result", (Metadata)metadata);
        Mockito.when((Object)this.factoryManager.newDiagram(Matchers.anyString(), (String)Matchers.eq((Object)DEF_SET_ID), (Metadata)Matchers.any())).thenReturn((Object)result);
        this.tested.transform(xml, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).onError((ClientRuntimeError)Matchers.any());
        ArgumentCaptor diagramArgumentCaptor = ArgumentCaptor.forClass(Diagram.class);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(diagramArgumentCaptor.capture());
        Diagram diagram = (Diagram)diagramArgumentCaptor.getValue();
        Assert.assertNotNull((Object)diagram);
        Assert.assertEquals((Object)result, (Object)diagram);
        Assert.assertEquals((Object)SHAPE_SET_ID, (Object)diagram.getMetadata().getShapeSetId());
    }

    @Test
    public void testGetDiagramTitleWhenIsEmpty() {
        String actual = this.tested.createDiagramTitleFromFilePath("");
        Assert.assertEquals((Object)"default", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsFileName() {
        String fileName = "file.dmn";
        String expected = "file";
        String actual = this.tested.createDiagramTitleFromFilePath("file.dmn");
        Assert.assertEquals((Object)"file", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsWindowsPath() {
        String fileName = "C:\\my path\\folder\\file.dmn";
        String expected = "file";
        String actual = this.tested.createDiagramTitleFromFilePath("C:\\my path\\folder\\file.dmn");
        Assert.assertEquals((Object)"file", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsUnixPath() {
        String fileName = "/users/user/file.dmn";
        String expected = "file";
        String actual = this.tested.createDiagramTitleFromFilePath("/users/user/file.dmn");
        Assert.assertEquals((Object)"file", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsWindowsPathMoreWords() {
        String fileName = "C:\\my path\\folder\\file a.dmn";
        String expected = "file a";
        String actual = this.tested.createDiagramTitleFromFilePath("C:\\my path\\folder\\file a.dmn");
        Assert.assertEquals((Object)"file a", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsUnixPathMoreWords() {
        String fileName = "/users/user/file a.dmn";
        String expected = "file a";
        String actual = this.tested.createDiagramTitleFromFilePath("/users/user/file a.dmn");
        Assert.assertEquals((Object)"file a", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenMoreDotsContained() {
        String fileName = "/users/user/file.template.dmn";
        String expected = "file.template";
        String actual = this.tested.createDiagramTitleFromFilePath("/users/user/file.template.dmn");
        Assert.assertEquals((Object)"file.template", (Object)actual);
    }

    @Test
    public void testGetDiagramTitleWhenIsNotFileNameOrEmpty() {
        String fileName = "Something";
        String expected = "Something";
        String actual = this.tested.createDiagramTitleFromFilePath("Something");
        Assert.assertEquals((Object)"Something", (Object)actual);
    }

    static {
        try {
            xml = BPMNClientDiagramServiceTest.loadStreamAsString(PATH_DIAGRAM);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

