/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.service;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.bpmn.project.service.BPMNDiagramEditorService;
import org.kie.workbench.common.stunner.bpmn.project.service.MigrationResult;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Service
public class BPMNDiagramEditorServiceImpl
implements BPMNDiagramEditorService {
    private IOService ioService;
    private CommentedOptionFactory optionFactory;

    public BPMNDiagramEditorServiceImpl() {
    }

    @Inject
    public BPMNDiagramEditorServiceImpl(@Named(value="ioStrategy") IOService ioService, CommentedOptionFactory optionFactory) {
        this.ioService = ioService;
        this.optionFactory = optionFactory;
    }

    public MigrationResult migrateDiagram(org.uberfire.backend.vfs.Path path, String newName, String newExtension, String commitMessage) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"newName", (Object)newName);
        PortablePreconditions.checkNotNull((String)"newExtension", (Object)newExtension);
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Path _target = _path.resolveSibling(newName + newExtension);
        if (this.ioService.exists(_target)) {
            return new MigrationResult(Paths.convert((Path)_target), BPMNDiagramEditorService.ServiceError.MIGRATION_ERROR_PROCESS_ALREADY_EXIST);
        }
        try {
            this.ioService.startBatch(_target.getFileSystem());
            this.ioService.move(_path, _target, new CopyOption[]{this.optionFactory.makeCommentedOption(commitMessage)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ioService.endBatch();
        }
        return new MigrationResult(Paths.convert((Path)_target));
    }
}

