/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.stunner.bpmn.forms.dataproviders.ProcessDataEvent;
import org.kie.workbench.common.stunner.bpmn.forms.dataproviders.RequestProcessDataEvent;
import org.kie.workbench.common.stunner.bpmn.project.backend.query.FindBpmnProcessIdsQuery;

@ApplicationScoped
public class ProcessesDataService {
    private final RefactoringQueryService queryService;
    private final Event<ProcessDataEvent> processDataEvent;
    private Supplier<ResourceType> resourceType;
    private Supplier<String> queryName;

    public ProcessesDataService() {
        this(null, null);
    }

    @Inject
    public ProcessesDataService(RefactoringQueryService queryService, Event<ProcessDataEvent> processDataEvent) {
        this.queryService = queryService;
        this.processDataEvent = processDataEvent;
        this.resourceType = () -> ResourceType.BPMN2;
        this.queryName = () -> FindBpmnProcessIdsQuery.NAME;
    }

    public List<String> getBusinessProcessIDs() {
        return this.getProcessIDs();
    }

    void onRequestProcessDataEvent(@Observes RequestProcessDataEvent event) {
        this.fireData();
    }

    public void setResourceType(Supplier<ResourceType> resourceType) {
        this.resourceType = resourceType;
    }

    public void setQueryName(Supplier<String> queryName) {
        this.queryName = queryName;
    }

    private void fireData() {
        List<String> processIds = this.getBusinessProcessIDs();
        this.processDataEvent.fire((Object)new ProcessDataEvent(processIds.toArray(new String[processIds.size()])));
    }

    private List<String> getProcessIDs() {
        Set queryTerms = new Sets.Builder().add((Object)new ValueResourceIndexTerm("*", this.resourceType.get(), ValueIndexTerm.TermSearchType.WILDCARD)).build();
        return this.queryService.query(this.queryName.get(), queryTerms).stream().map(row -> (Map)row.getValue()).flatMap(mapRow -> mapRow.keySet().stream()).filter(pId -> !"null".equals(pId)).distinct().collect(Collectors.toList());
    }
}

