/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.indexing;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.io.impl.ReaderResource;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.process.core.validation.ProcessValidator;
import org.jbpm.process.core.validation.ProcessValidatorRegistry;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.IndexBuilder;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.stunner.bpmn.project.backend.indexing.AbstractBpmnProcessDataEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

public abstract class AbstractBpmnFileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBpmnFileIndexer.class);
    private static final SemanticModules modules = new SemanticModules();
    @Inject
    protected ModuleClassLoaderHelper classLoaderHelper;

    protected IndexBuilder fillIndexBuilder(Path path) throws Exception {
        KieModule module = (KieModule)this.moduleService.resolveModule(Paths.convert((Path)path));
        if (module == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": module could not be resolved.");
            return null;
        }
        DefaultIndexBuilder builder = this.getIndexBuilder(path, (Module)module);
        String bpmnStr = this.ioService.readAllString(path);
        ClassLoader moduleClassLoader = this.getModuleClassLoader(module);
        try {
            List<AbstractBpmnProcessDataEventListener> processDataList = this.buildProcessDefinition(bpmnStr, moduleClassLoader);
            if (processDataList != null) {
                for (AbstractBpmnProcessDataEventListener processData : processDataList) {
                    this.addReferencedResourcesToIndexBuilder(builder, processData);
                    builder.setPackageName(processData.getProcess().getPackageName());
                }
            }
        }
        catch (Exception e) {
            logger.info("Indexing hampered because BPMN2 compilation failed [" + path.toString() + "]: " + e.getMessage());
        }
        XmlProcessReader processReader = new XmlProcessReader(modules, moduleClassLoader);
        List processes = Collections.emptyList();
        try {
            processes = processReader.read((Reader)new StringReader(bpmnStr));
        }
        catch (Exception e) {
            logger.info("Unable to index because BPMN2 parsing failed [" + path.toString() + "]: " + e.getMessage());
        }
        if (processes != null) {
            for (Process process : processes) {
                ReaderResource resource = new ReaderResource((Reader)new StringReader(bpmnStr));
                ProcessValidator validator = ProcessValidatorRegistry.getInstance().getValidator(process, (Resource)resource);
                ProcessValidationError[] errors = validator.validateProcess(process);
                if (errors.length > 0) {
                    logger.error("Trying to finish indexing process '" + process.getId() + "/" + process.getName() + "' despite " + errors.length + " validation errors.");
                }
                processReader.getProcessBuildData().onBuildComplete(process);
                AbstractBpmnProcessDataEventListener helper = (AbstractBpmnProcessDataEventListener)process.getMetaData().get(this.getProcessDescriptorName());
                this.addReferencedResourcesToIndexBuilder(builder, helper);
            }
        } else {
            logger.warn("No process was found in file: " + path.toUri());
        }
        return builder;
    }

    protected ClassLoader getModuleClassLoader(KieModule module) {
        return this.classLoaderHelper.getModuleClassLoader(module);
    }

    private List<AbstractBpmnProcessDataEventListener> buildProcessDefinition(String bpmn2Content, ClassLoader moduleClassLoader) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)bpmn2Content)) {
            return Collections.emptyList();
        }
        KnowledgeBuilder kbuilder = null;
        if (moduleClassLoader != null) {
            KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{moduleClassLoader});
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pconf);
        } else {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        }
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                logger.error("Error: {}", (Object)error.getMessage());
            }
            logger.debug("Process Cannot be Parsed! \n {} \n", (Object)bpmn2Content);
            return Collections.emptyList();
        }
        ArrayList<AbstractBpmnProcessDataEventListener> processDataList = new ArrayList<AbstractBpmnProcessDataEventListener>();
        kbuilder.getKnowledgePackages().forEach(pkg -> pkg.getProcesses().forEach(p -> {
            AbstractBpmnProcessDataEventListener processData = (AbstractBpmnProcessDataEventListener)p.getMetaData().get(this.getProcessDescriptorName());
            processDataList.add(processData);
        }));
        return processDataList;
    }

    protected DefaultIndexBuilder getIndexBuilder(Path path, Module module) {
        Package pkg = this.moduleService.resolvePackage(Paths.convert((Path)path));
        if (pkg == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": package could not be resolved.");
            return null;
        }
        return new DefaultIndexBuilder(Paths.convert((Path)path).getFileName(), module, pkg);
    }

    protected abstract String getProcessDescriptorName();

    static {
        modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
    }
}

